/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.tpk;

import java.util.Comparator;

public class TPKTile {
    public long zoomLevel;
    public long col;
    public long row;
    public String imageFormat;
    public byte[] tileData;
    public TileInfo tileInfo;
    public int bundleNum;

    public TPKTile(long zoomLevel, long col, long row, String imageFormat, TileInfo tileInfo, int bundleNum) {
        this.zoomLevel = zoomLevel;
        this.col = col;
        this.row = row;
        this.imageFormat = imageFormat;
        this.tileInfo = tileInfo;
        this.bundleNum = bundleNum;
    }

    public void setTileData(byte[] tileData) {
        this.tileData = tileData;
    }

    public static class TileInfo {
        int tileLength;
        long tileDataOffset;

        TileInfo(int tileLength, long tileDataOffset) {
            this.tileLength = tileLength;
            this.tileDataOffset = tileDataOffset;
        }
    }

    public static class TPKTileSorter
    implements Comparator<TPKTile> {
        @Override
        public int compare(TPKTile a, TPKTile b) {
            int temp = a.bundleNum - b.bundleNum;
            if (temp != 0) {
                return temp;
            }
            return (int)(a.tileInfo.tileDataOffset - b.tileInfo.tileDataOffset);
        }
    }
}

