/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.tpk;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.function.Supplier;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class TPKBundle {
    private Supplier<ZipFile> TPKFile;
    private Supplier<Map<String, ZipEntry>> zipEntryMap;
    public SequentialInputFile bundleData;
    public SequentialInputFile bundleIndx;
    public long baseRow;
    public long baseColumn;
    public long minRow;
    public long maxRow;
    public long minColumn;
    public long maxColumn;

    public TPKBundle(String bundleName, String indexName, long baseColumn, long baseRow, Supplier<ZipFile> TPKFile2, Supplier<Map<String, ZipEntry>> zipEntryMap) {
        this.TPKFile = TPKFile2;
        this.zipEntryMap = zipEntryMap;
        this.bundleData = new SequentialInputFile(bundleName);
        if (indexName != null) {
            this.bundleIndx = new SequentialInputFile(indexName);
        }
        this.baseColumn = baseColumn;
        this.baseRow = baseRow;
        this.minColumn = Long.MAX_VALUE;
        this.maxColumn = Long.MIN_VALUE;
        this.minRow = Long.MAX_VALUE;
        this.maxRow = Long.MIN_VALUE;
    }

    public void releaseResources() {
        this.bundleData.close();
        if (this.bundleIndx != null) {
            this.bundleIndx.close();
        }
    }

    public boolean inBundle(long column, long row) {
        return column >= this.minColumn && column <= this.maxColumn && row >= this.minRow && row <= this.maxRow;
    }

    public class SequentialInputFile {
        private String name;
        private InputStream stream;
        private long currentReadPosition;

        private SequentialInputFile(String name) {
            this.name = name;
            this.stream = null;
            this.currentReadPosition = 0L;
        }

        public byte[] read(long offset, int length) {
            byte[] result = new byte[length];
            try {
                if (this.currentReadPosition > offset || this.stream == null) {
                    if (this.stream != null) {
                        this.stream.close();
                        this.currentReadPosition = 0L;
                    }
                    ZipEntry zipEntry = TPKBundle.this.zipEntryMap.get().get(this.name);
                    this.stream = TPKBundle.this.TPKFile.get().getInputStream(zipEntry);
                }
                long toSkip = offset - this.currentReadPosition;
                while (toSkip > 0L) {
                    long skipped = this.stream.skip(toSkip);
                    toSkip -= skipped;
                    this.currentReadPosition += skipped;
                }
                int readOffset = 0;
                while (length > 0) {
                    int bytesRead = this.stream.read(result, readOffset, length);
                    if (bytesRead == -1) {
                        Logger.getLogger(this.getClass().getName()).warning("Didn't read correctly");
                        length = 0;
                        result = null;
                        continue;
                    }
                    readOffset += bytesRead;
                    this.currentReadPosition += (long)bytesRead;
                    length -= bytesRead;
                }
            }
            catch (IOException ex) {
                throw new RuntimeException("Caught error reading sequential input ZipEntry stream");
            }
            return result;
        }

        private void close() {
            if (this.stream != null) {
                try {
                    this.stream.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.stream = null;
            }
            this.currentReadPosition = 0L;
        }
    }
}

