/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.tile.impl.bing;

import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.tile.Tile;
import org.geotools.tile.TileIdentifier;
import org.geotools.tile.TileService;
import org.geotools.tile.impl.WebMercatorTileFactory;
import org.geotools.tile.impl.ZoomLevel;
import org.geotools.tile.impl.bing.BingTileIdentifier;
import org.geotools.util.logging.Logging;

public class BingTile
extends Tile {
    public static final int DEFAULT_TILE_SIZE = 256;
    private static final Logger LOGGER = Logging.getLogger(BingTile.class);

    public BingTile(int x, int y, ZoomLevel zoomLevel, TileService service) {
        this(new BingTileIdentifier(x, y, zoomLevel, service.getName()), service);
    }

    public BingTile(TileIdentifier tileName, TileService service) {
        super(tileName, WebMercatorTileFactory.getExtentFromTileName(tileName), 256, service);
    }

    @Override
    public URL getUrl() {
        String url = this.service.getBaseUrl().replace("${code}", this.getTileIdentifier().getCode());
        try {
            return new URL(url);
        }
        catch (Exception e) {
            String mesg = "Cannot create URL from " + url;
            LOGGER.log(Level.SEVERE, mesg, e);
            throw new RuntimeException(mesg, e);
        }
    }
}

