/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.tile.impl.osm;

import org.geotools.tile.Tile;
import org.geotools.tile.TileFactory;
import org.geotools.tile.TileService;
import org.geotools.tile.impl.WebMercatorTileFactory;
import org.geotools.tile.impl.ZoomLevel;
import org.geotools.tile.impl.osm.OSMTile;

public class OSMTileFactory
extends WebMercatorTileFactory {
    @Override
    public Tile findTileAtCoordinate(double lon, double lat, ZoomLevel zoomLevel, TileService service) {
        lat = TileFactory.normalizeDegreeValue(lat, 90);
        lon = TileFactory.normalizeDegreeValue(lon, 180);
        lat = OSMTileFactory.moveInRange(lat, -85.05112878, 85.05112878);
        int xTile = (int)Math.floor((lon + 180.0) / 360.0 * (double)(1 << zoomLevel.getZoomLevel()));
        int yTile = (int)Math.floor((1.0 - Math.log(Math.tan(lat * Math.PI / 180.0) + 1.0 / Math.cos(lat * Math.PI / 180.0)) / Math.PI) / 2.0 * (double)(1 << zoomLevel.getZoomLevel()));
        if (yTile < 0) {
            yTile = 0;
        }
        return new OSMTile(xTile, yTile, zoomLevel, service);
    }

    public static double moveInRange(double value, double min, double max) {
        if (value < min) {
            value = min;
        } else if (value > max) {
            value = max;
        }
        return value;
    }

    @Override
    public Tile findRightNeighbour(Tile tile, TileService service) {
        return new OSMTile(tile.getTileIdentifier().getRightNeighbour(), service);
    }

    @Override
    public Tile findLowerNeighbour(Tile tile, TileService service) {
        return new OSMTile(tile.getTileIdentifier().getLowerNeighbour(), service);
    }
}

