/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.tile.impl.bing;

import org.geotools.tile.Tile;
import org.geotools.tile.TileService;
import org.geotools.tile.impl.WebMercatorTileFactory;
import org.geotools.tile.impl.ZoomLevel;
import org.geotools.tile.impl.bing.BingTile;
import org.geotools.tile.impl.bing.BingTileUtil;

class BingTileFactory
extends WebMercatorTileFactory {
    BingTileFactory() {
    }

    @Override
    public Tile findTileAtCoordinate(double lon, double lat, ZoomLevel zoomLevel, TileService service) {
        int[] tileXY = BingTileUtil.lonLatToPixelXY(lon, lat, zoomLevel.getZoomLevel());
        int colX = (int)Math.floor(tileXY[0] / 256);
        int rowY = (int)Math.floor(tileXY[1] / 256);
        return new BingTile(colX, rowY, zoomLevel, service);
    }

    @Override
    public Tile findRightNeighbour(Tile tile, TileService service) {
        return new BingTile(tile.getTileIdentifier().getRightNeighbour(), service);
    }

    @Override
    public Tile findLowerNeighbour(Tile tile, TileService service) {
        return new BingTile(tile.getTileIdentifier().getLowerNeighbour(), service);
    }
}

