/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.tile;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.data.ows.HTTPClient;
import org.geotools.data.ows.SimpleHttpClient;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.tile.Tile;
import org.geotools.tile.TileFactory;
import org.geotools.tile.impl.ScaleZoomLevelMatcher;
import org.geotools.util.ObjectCache;
import org.geotools.util.ObjectCaches;
import org.geotools.util.logging.Logging;
import org.locationtech.jts.geom.Envelope;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.TransformException;

public abstract class TileService {
    protected static final Logger LOGGER = Logging.getLogger(TileService.class);
    private ObjectCache tiles = ObjectCaches.create((String)"soft", (int)50);
    private String baseURL;
    private String name;
    private final HTTPClient client;

    protected TileService(String name, String baseURL) {
        this(name, baseURL, (HTTPClient)new SimpleHttpClient());
    }

    protected TileService(String name, String baseURL, HTTPClient client) {
        this.setName(name);
        this.setBaseURL(baseURL);
        Objects.requireNonNull(client);
        this.client = client;
    }

    private void setBaseURL(String baseURL) {
        if (baseURL == null || baseURL.isEmpty()) {
            throw new IllegalArgumentException("Base URL cannot be null");
        }
        this.baseURL = baseURL;
    }

    private void setName(String name) {
        if (name == null || name.isEmpty()) {
            throw new IllegalArgumentException("Name cannot be null");
        }
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public int getTileWidth() {
        return 256;
    }

    public int getTileHeight() {
        return 256;
    }

    public String getBaseUrl() {
        return this.baseURL;
    }

    public CoordinateReferenceSystem getTileCrs() {
        return DefaultGeographicCRS.WGS84;
    }

    public int getZoomLevelFromMapScale(ScaleZoomLevelMatcher zoomLevelMatcher, double scaleFactor) {
        double[] scaleList = this.getScaleList();
        assert (scaleList != null && scaleList.length > 0);
        double[] tempScaleList = new double[scaleList.length];
        Arrays.fill(tempScaleList, Double.NaN);
        int zoomLevel = zoomLevelMatcher.getZoomLevelFromScale(this, tempScaleList);
        if (zoomLevel == 0) {
            return zoomLevel;
        }
        int upperScaleIndex = zoomLevel - 1;
        int lowerScaleIndex = zoomLevel;
        double deltaScale = tempScaleList[upperScaleIndex] - tempScaleList[lowerScaleIndex];
        double rangeScale = scaleFactor / 100.0 * deltaScale;
        double limitScale = tempScaleList[lowerScaleIndex] + rangeScale;
        if (zoomLevelMatcher.getScale() > limitScale) {
            return upperScaleIndex;
        }
        return lowerScaleIndex;
    }

    public int getZoomLevelToUse(ScaleZoomLevelMatcher zoomLevelMatcher, double scaleFactor, boolean useRecommended) {
        if (useRecommended) {
            return this.getZoomLevelFromMapScale(zoomLevelMatcher, scaleFactor);
        }
        boolean selectionAutomatic = true;
        int zoomLevel = -1;
        if (!selectionAutomatic && zoomLevel >= this.getMinZoomLevel() && zoomLevel <= this.getMaxZoomLevel()) {
            return zoomLevel;
        }
        return this.getZoomLevelFromMapScale(zoomLevelMatcher, scaleFactor);
    }

    public int getMinZoomLevel() {
        int minZoomLevel;
        double[] scaleList = this.getScaleList();
        for (minZoomLevel = 0; Double.isNaN(scaleList[minZoomLevel]) && minZoomLevel < scaleList.length; ++minZoomLevel) {
        }
        return minZoomLevel;
    }

    public int getMaxZoomLevel() {
        int maxZoomLevel;
        double[] scaleList = this.getScaleList();
        for (maxZoomLevel = scaleList.length - 1; Double.isNaN(scaleList[maxZoomLevel]) && maxZoomLevel >= 0; --maxZoomLevel) {
        }
        return maxZoomLevel;
    }

    /*
     * Unable to fully structure code
     */
    public Set<Tile> findTilesInExtent(ReferencedEnvelope _mapExtent, double scaleFactor, boolean recommendedZoomLevel, int maxNumberOfTiles) {
        mapExtent = TileService.createSafeEnvelopeInWGS84(_mapExtent);
        extent = this.normalizeExtent(mapExtent);
        if (!extent.intersects((Envelope)this.getBounds())) {
            return Collections.emptySet();
        }
        tileFactory = this.getTileFactory();
        zoomLevelMatcher = null;
        try {
            zoomLevelMatcher = new ScaleZoomLevelMatcher(this.getTileCrs(), this.getProjectedTileCrs(), CRS.findMathTransform((CoordinateReferenceSystem)this.getTileCrs(), (CoordinateReferenceSystem)this.getProjectedTileCrs()), CRS.findMathTransform((CoordinateReferenceSystem)this.getProjectedTileCrs(), (CoordinateReferenceSystem)this.getTileCrs()), mapExtent, mapExtent, scaleFactor);
        }
        catch (FactoryException e) {
            throw new RuntimeException(e);
        }
        zoomLevelA = this.getZoomLevelToUse(zoomLevelMatcher, scaleFactor, recommendedZoomLevel) - 1;
        if (zoomLevelA <= 0) {
            zoomLevelA = 0;
        }
        zoomLevel = tileFactory.getZoomLevel(zoomLevelA, this);
        maxNumberOfTilesForZoomLevel = zoomLevel.getMaxTileNumber();
        tileList = new HashSet<Tile>(100);
        firstTile = tileFactory.findTileAtCoordinate(extent.getMinX(), extent.getMaxY(), zoomLevel, this);
        this.addTileToCache(firstTile);
        tileList.add(firstTile);
        firstTileOfRow = firstTile;
        movingTile = firstTile;
        do lbl-1000:
        // 3 sources

        {
            block6: {
                if (!extent.intersects((Envelope)(rightNeighbour = tileFactory.findRightNeighbour(movingTile, this)).getExtent()) || firstTileOfRow.equals(rightNeighbour)) break block6;
                this.addTileToCache(rightNeighbour);
                tileList.add(rightNeighbour);
                movingTile = rightNeighbour;
                if (tileList.size() > maxNumberOfTiles) {
                    TileService.LOGGER.warning("Reached tile limit of " + maxNumberOfTiles + ". Returning an empty collection.");
                    return Collections.emptySet();
                }
                if ((long)tileList.size() < maxNumberOfTilesForZoomLevel) ** GOTO lbl-1000
            }
            if (!extent.intersects((Envelope)(lowerNeighbour = tileFactory.findLowerNeighbour(firstTileOfRow, this)).getExtent()) || firstTile.equals(lowerNeighbour)) break;
            this.addTileToCache(lowerNeighbour);
            tileList.add(lowerNeighbour);
            firstTileOfRow = movingTile = lowerNeighbour;
        } while ((long)tileList.size() < maxNumberOfTilesForZoomLevel);
        return tileList;
    }

    protected Tile addTileToCache(Tile tile) {
        boolean isInCache;
        String id = tile.getId();
        boolean bl = isInCache = this.tiles.peek((Object)id) != null && this.tiles.get((Object)id) != null;
        if (isInCache) {
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.fine("Tile already in cache: " + id);
            }
            return (Tile)this.tiles.get((Object)id);
        }
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.fine("Tile added to cache: " + id);
        }
        this.tiles.put((Object)id, (Object)tile);
        return tile;
    }

    public abstract double[] getScaleList();

    public abstract ReferencedEnvelope getBounds();

    public abstract CoordinateReferenceSystem getProjectedTileCrs();

    public abstract TileFactory getTileFactory();

    public static final ReferencedEnvelope createSafeEnvelopeInWGS84(ReferencedEnvelope _mapExtent) {
        try {
            return _mapExtent.transform((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84, true);
        }
        catch (TransformException e) {
            throw new RuntimeException(e);
        }
        catch (FactoryException e) {
            throw new RuntimeException(e);
        }
    }

    private ReferencedEnvelope normalizeExtent(ReferencedEnvelope envelope) {
        ReferencedEnvelope bounds = this.getBounds();
        if (envelope.getMaxY() > bounds.getMaxY() || envelope.getMinY() < bounds.getMinY() || envelope.getMaxX() > bounds.getMaxX() || envelope.getMinX() < bounds.getMinX()) {
            double maxY = envelope.getMaxY() > bounds.getMaxY() ? bounds.getMaxY() : envelope.getMaxY();
            double minY = envelope.getMinY() < bounds.getMinY() ? bounds.getMinY() : envelope.getMinY();
            double maxX = envelope.getMaxX() > bounds.getMaxX() ? bounds.getMaxX() : envelope.getMaxX();
            double minX = envelope.getMinX() < bounds.getMinX() ? bounds.getMinX() : envelope.getMinX();
            ReferencedEnvelope newEnvelope = new ReferencedEnvelope(minX, maxX, minY, maxY, envelope.getCoordinateReferenceSystem());
            return newEnvelope;
        }
        return envelope;
    }

    public String toString() {
        return this.getName();
    }

    public final HTTPClient getHttpClient() {
        return this.client;
    }
}

