/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.tile;

import org.geotools.tile.Tile;
import org.geotools.tile.TileService;
import org.geotools.tile.impl.ZoomLevel;

public abstract class TileFactory {
    public abstract Tile findTileAtCoordinate(double var1, double var3, ZoomLevel var5, TileService var6);

    public abstract ZoomLevel getZoomLevel(int var1, TileService var2);

    public abstract Tile findRightNeighbour(Tile var1, TileService var2);

    public abstract Tile findLowerNeighbour(Tile var1, TileService var2);

    public static double normalizeDegreeValue(double value, int maxValue) {
        int range = 2 * maxValue;
        if (value > 0.0) {
            if ((value = (value + (double)maxValue - 1.0) % (double)range) < 0.0) {
                value += (double)range;
            }
            return value - (double)maxValue + 1.0;
        }
        if ((value = (value + (double)maxValue) % (double)range) < 0.0) {
            value += (double)range;
        }
        return value - (double)maxValue;
    }
}

