/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.tile.impl.osm;

import org.geotools.tile.Tile;
import org.geotools.tile.TileIdentifier;
import org.geotools.tile.TileService;
import org.geotools.tile.impl.WebMercatorTileFactory;
import org.geotools.tile.impl.ZoomLevel;
import org.geotools.tile.impl.osm.OSMTile;

public class OSMTileFactory
extends WebMercatorTileFactory {
    @Override
    public Tile create(TileIdentifier identifier, TileService service) {
        return new OSMTile(identifier, service);
    }

    @Override
    public Tile findTileAtCoordinate(double lon, double lat, ZoomLevel zoomLevel, TileService service) {
        return this.create(service.identifyTileAtCoordinate(lon, lat, zoomLevel), service);
    }

    public static double moveInRange(double value, double min, double max) {
        if (value < min) {
            value = min;
        } else if (value > max) {
            value = max;
        }
        return value;
    }

    @Override
    public Tile findRightNeighbour(Tile tile, TileService service) {
        return this.create(tile.getTileIdentifier().getRightNeighbour(), service);
    }

    @Override
    public Tile findLowerNeighbour(Tile tile, TileService service) {
        return this.create(tile.getTileIdentifier().getLowerNeighbour(), service);
    }
}

