/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.tile.impl.bing;

import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.locationtech.jts.geom.Envelope;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public final class BingTileUtil {
    private BingTileUtil() {
    }

    public static int[] lonLatToPixelXY(double longitude, double latitude, int zoomLevel) {
        double _latitude = BingTileUtil.clip(latitude, -85.05112878, 85.05112878);
        double _longitude = BingTileUtil.clip(longitude, -180.0, 180.0);
        double x = (_longitude + 180.0) / 360.0;
        double sinLatitude = Math.sin(_latitude * Math.PI / 180.0);
        double y = 0.5 - Math.log((1.0 + sinLatitude) / (1.0 - sinLatitude)) / (Math.PI * 4);
        int mapSize = BingTileUtil.mapSize(zoomLevel);
        int pixelX = (int)BingTileUtil.clip(x * (double)mapSize + 0.5, 0.0, mapSize - 1);
        int pixelY = (int)BingTileUtil.clip(y * (double)mapSize + 0.5, 0.0, mapSize - 1);
        return new int[]{pixelX, pixelY};
    }

    public static double[] pixelXYToLonLat(int pixelX, int pixelY, int zoomLevel) {
        double mapSize = BingTileUtil.mapSize(zoomLevel);
        double x = BingTileUtil.clip(pixelX, 0.0, mapSize - 1.0) / mapSize - 0.5;
        double y = 0.5 - BingTileUtil.clip(pixelY, 0.0, mapSize - 1.0) / mapSize;
        double latitude = 90.0 - 360.0 * Math.atan(Math.exp(-y * 2.0 * Math.PI)) / Math.PI;
        double longitude = 360.0 * x;
        return new double[]{longitude, latitude};
    }

    public static int mapSize(int zoomLevel) {
        return 256 << zoomLevel;
    }

    public static int[] pixelXYToTileXY(int pixelX, int pixelY) {
        int tileX = pixelX / 256;
        int tileY = pixelY / 256;
        return new int[]{tileX, tileY};
    }

    public static String tileXYToQuadKey(int tileX, int tileY, int zoomLevel) {
        StringBuilder quadKey = new StringBuilder();
        for (int i = zoomLevel; i > 0; --i) {
            char digit = '0';
            int mask = 1 << i - 1;
            if ((tileX & mask) != 0) {
                digit = (char)(digit + 1);
            }
            if ((tileY & mask) != 0) {
                digit = (char)(digit + 1);
                digit = (char)(digit + '\u0001');
            }
            quadKey.append(digit);
        }
        return quadKey.toString();
    }

    private static double clip(double n, double minValue, double maxValue) {
        return Math.min(Math.max(n, minValue), maxValue);
    }

    public static String lonLatToQuadKey(double lon, double lat, int zoomLevel) {
        int[] pixelXY = BingTileUtil.lonLatToPixelXY(lon, lat, zoomLevel);
        int[] tileXY = BingTileUtil.pixelXYToTileXY(pixelXY[0], pixelXY[1]);
        return BingTileUtil.tileXYToQuadKey(tileXY[0], tileXY[1], zoomLevel);
    }

    public static ReferencedEnvelope getTileBoundingBox(double lon, double lat, int zoomLevel) {
        int[] imageXY = BingTileUtil.lonLatToPixelXY(lon, lat, zoomLevel);
        int numberOfTilesX = imageXY[0] / 256;
        int numberOfTilesY = imageXY[1] / 256;
        int tileTopLeftPixelX = numberOfTilesX * 256;
        int tileTopLeftPixelY = numberOfTilesY * 256;
        double[] topLeftCoords = BingTileUtil.pixelXYToLonLat(tileTopLeftPixelX, tileTopLeftPixelY, zoomLevel);
        double[] bottomRightCoords = BingTileUtil.pixelXYToLonLat(tileTopLeftPixelX + 256, tileTopLeftPixelY + 256, zoomLevel);
        Envelope envelope = new Envelope(topLeftCoords[0], bottomRightCoords[0], topLeftCoords[1], bottomRightCoords[1]);
        return new ReferencedEnvelope(envelope, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
    }
}

