/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.tile;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.http.HTTPResponse;
import org.geotools.image.io.ImageIOExt;
import org.geotools.tile.ImageLoader;
import org.geotools.tile.TileIdentifier;
import org.geotools.tile.TileService;
import org.geotools.tile.TileStateChangedListener;
import org.geotools.util.logging.Logging;

public abstract class Tile
implements ImageLoader {
    protected static final Logger LOGGER = Logging.getLogger((String)"org.geotools.tile.loader");
    private ReferencedEnvelope env;
    private int tileSize;
    private TileIdentifier tileIdentifier;
    private RenderState renderState = RenderState.NEW;
    private ContextState contextState = ContextState.INVALID;
    private ScreenState screenState = ScreenState.OFFSCREEN;
    private ValidatedState tileState = ValidatedState.VALIDATED;
    private TileStateChangedListener listener = null;
    private BufferedImage tileImage = null;
    private ImageLoader imageLoader = this;
    protected TileService service = null;

    public void setImageLoader(ImageLoader imageLoader) {
        if (imageLoader == null) {
            throw new IllegalArgumentException("ImageLoader cannot be null");
        }
        this.imageLoader = imageLoader;
    }

    public Tile(TileIdentifier tileId, ReferencedEnvelope env, int tileSize) {
        if (env == null) {
            throw new IllegalArgumentException("Envelope cannot be null");
        }
        this.env = env;
        this.tileSize = tileSize;
        if (tileId == null) {
            throw new IllegalArgumentException("TileIdentifier cannot be null");
        }
        this.tileIdentifier = tileId;
    }

    public Tile(TileIdentifier tileId, ReferencedEnvelope env, int tileSize, TileService service) {
        this(tileId, env, tileSize);
        this.imageLoader = service;
        this.service = service;
    }

    public void setStateChangedListener(TileStateChangedListener listener) {
        this.listener = listener;
    }

    public void dispose() {
        this.setScreenState(ScreenState.OFFSCREEN);
    }

    public BufferedImage getBufferedImage() {
        if (this.isImageLoadedOK()) {
            return this.tileImage;
        }
        try {
            this.tileImage = this.imageLoader.loadImageTileImage(this);
            this.setRenderState(RenderState.RENDERED);
            return this.tileImage;
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Failed to load image: " + String.valueOf(this.getUrl()), e);
            this.setRenderState(RenderState.INVALID);
            return this.createErrorImage("Failed: " + this.getId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BufferedImage loadImageTileImage(Tile tile) throws IOException {
        if (this.service == null) {
            throw new IllegalStateException("service cannot be null.");
        }
        HTTPResponse response = this.service.getHttpClient().get(tile.getUrl());
        try {
            BufferedImage bufferedImage = ImageIOExt.readBufferedImage((Object)response.getResponseStream());
            return bufferedImage;
        }
        finally {
            response.dispose();
        }
    }

    private boolean isImageLoadedOK() {
        return this.renderState == RenderState.RENDERED && this.tileImage != null;
    }

    protected BufferedImage createErrorImage(String message) {
        int size = this.getTileSize();
        BufferedImage buffImage = new BufferedImage(size, size, 2);
        Graphics2D graphics = buffImage.createGraphics();
        graphics.setComposite(AlphaComposite.getInstance(3, 0.5f));
        graphics.setColor(Color.WHITE);
        graphics.fillRect(0, 0, size, size);
        graphics.setColor(Color.RED);
        graphics.drawLine(0, 0, size, size);
        graphics.drawLine(0, size, size, 0);
        int mesgWidth = graphics.getFontMetrics().stringWidth(message);
        graphics.drawString(message, (size - mesgWidth) / 2, size / 2);
        graphics.dispose();
        return buffImage;
    }

    public int getTileSize() {
        return this.tileSize;
    }

    public ReferencedEnvelope getExtent() {
        return this.env;
    }

    public void setRenderState(RenderState newState) {
        this.renderState = newState;
        if (this.listener != null) {
            this.listener.renderStateChanged(this);
        }
    }

    public RenderState getRenderState() {
        return this.renderState;
    }

    public ContextState getContextState() {
        return this.contextState;
    }

    public void setContextState(ContextState newState) {
        this.contextState = newState;
        if (this.listener != null) {
            this.listener.contextStateChanged(this);
        }
    }

    public ScreenState getScreenState() {
        return this.screenState;
    }

    public void setScreenState(ScreenState newState) {
        this.screenState = newState;
        if (this.listener != null) {
            this.listener.screenStateChanged(this);
        }
    }

    public ValidatedState getTileState() {
        return this.tileState;
    }

    public void setTileState(ValidatedState newState) {
        this.tileState = newState;
        if (this.listener != null) {
            this.listener.validationStateChanged(this);
        }
    }

    public String getId() {
        return this.tileIdentifier.getId();
    }

    public TileIdentifier getTileIdentifier() {
        return this.tileIdentifier;
    }

    public int hashCode() {
        return this.getUrl().hashCode();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Tile)) {
            return false;
        }
        return this.getUrl().equals(((Tile)other).getUrl());
    }

    public String toString() {
        return this.getId();
    }

    public abstract URL getUrl();

    public static enum ValidatedState {
        VALIDATED,
        OLD;

    }

    public static enum ScreenState {
        ONSCREEN,
        OFFSCREEN;

    }

    public static enum ContextState {
        OKAY,
        INVALID;

    }

    public static enum RenderState {
        NEW,
        RENDERED,
        INVALID;

    }
}

