/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import net.miginfocom.swing.MigLayout;
import org.geotools.map.MapContent;
import org.geotools.swing.JMapPane;
import org.geotools.swing.MapLayerTable;
import org.geotools.swing.action.InfoAction;
import org.geotools.swing.action.NoToolAction;
import org.geotools.swing.action.PanAction;
import org.geotools.swing.action.ResetAction;
import org.geotools.swing.action.ZoomInAction;
import org.geotools.swing.action.ZoomOutAction;
import org.geotools.swing.control.JMapStatusBar;
import org.geotools.swing.tool.ScrollWheelTool;

public class JMapFrame
extends JFrame {
    public static final String TOOLBAR_INFO_BUTTON_NAME = "ToolbarInfoButton";
    public static final String TOOLBAR_PAN_BUTTON_NAME = "ToolbarPanButton";
    public static final String TOOLBAR_POINTER_BUTTON_NAME = "ToolbarPointerButton";
    public static final String TOOLBAR_RESET_BUTTON_NAME = "ToolbarResetButton";
    public static final String TOOLBAR_ZOOMIN_BUTTON_NAME = "ToolbarZoomInButton";
    public static final String TOOLBAR_ZOOMOUT_BUTTON_NAME = "ToolbarZoomOutButton";
    private boolean showToolBar;
    private Set<Tool> toolSet;
    private JMapPane mapPane;
    private MapLayerTable mapLayerTable;
    private JToolBar toolBar;
    private boolean showStatusBar;
    private boolean showLayerTable;
    private boolean uiSet;

    public static void showMap(MapContent content) {
        if (SwingUtilities.isEventDispatchThread()) {
            JMapFrame.doShowMap(content);
        } else {
            SwingUtilities.invokeLater(() -> JMapFrame.doShowMap(content));
        }
    }

    private static void doShowMap(MapContent content) {
        JMapFrame frame = new JMapFrame(content);
        frame.enableStatusBar(true);
        frame.enableToolBar(true);
        frame.initComponents();
        frame.setSize(800, 600);
        frame.setVisible(true);
    }

    public JMapFrame() {
        this((MapContent)null);
    }

    public JMapFrame(MapContent content) {
        super(content == null ? "" : content.getTitle());
        this.setDefaultCloseOperation(3);
        this.showLayerTable = false;
        this.showStatusBar = false;
        this.showToolBar = false;
        this.toolSet = EnumSet.noneOf(Tool.class);
        this.mapPane = new JMapPane(content);
        this.mapPane.setBackground(Color.WHITE);
        this.mapPane.setBorder(BorderFactory.createLineBorder(Color.BLACK));
        this.addWindowFocusListener(new WindowAdapter(){

            @Override
            public void windowGainedFocus(WindowEvent e) {
                JMapFrame.this.mapPane.requestFocusInWindow();
            }
        });
        this.mapPane.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                JMapFrame.this.mapPane.setBorder(BorderFactory.createLineBorder(Color.BLACK));
            }

            @Override
            public void focusLost(FocusEvent e) {
                JMapFrame.this.mapPane.setBorder(BorderFactory.createLineBorder(Color.LIGHT_GRAY));
            }
        });
        this.mapPane.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                JMapFrame.this.mapPane.requestFocusInWindow();
            }
        });
    }

    public void enableToolBar(boolean enabled) {
        if (enabled) {
            this.toolSet = EnumSet.allOf(Tool.class);
        } else {
            this.toolSet.clear();
        }
        this.showToolBar = enabled;
    }

    public void enableTool(Tool ... tool) {
        if (tool == null || tool.length == 0) {
            this.enableToolBar(false);
        } else {
            this.toolSet = EnumSet.copyOf(Arrays.asList(tool));
            this.showToolBar = true;
        }
    }

    public void enableStatusBar(boolean enabled) {
        this.showStatusBar = enabled;
    }

    public void enableLayerTable(boolean enabled) {
        this.showLayerTable = enabled;
    }

    @Override
    public void setVisible(boolean state) {
        if (state && !this.uiSet) {
            this.initComponents();
        }
        super.setVisible(state);
    }

    public void initComponents() {
        if (this.uiSet) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        if (!this.toolSet.isEmpty()) {
            sb.append("[]");
        }
        sb.append("[grow]");
        if (this.showStatusBar) {
            sb.append("[min!]");
        }
        JPanel panel = new JPanel((LayoutManager)new MigLayout("wrap 1, insets 0", "[grow]", sb.toString()));
        if (this.showToolBar) {
            JButton btn;
            this.toolBar = new JToolBar();
            this.toolBar.setOrientation(0);
            this.toolBar.setFloatable(false);
            ButtonGroup cursorToolGrp = new ButtonGroup();
            if (this.toolSet.contains((Object)Tool.SCROLLWHEEL)) {
                this.mapPane.addMouseListener(new ScrollWheelTool(this.mapPane));
            }
            if (this.toolSet.contains((Object)Tool.POINTER)) {
                btn = new JButton(new NoToolAction(this.mapPane));
                btn.setName(TOOLBAR_POINTER_BUTTON_NAME);
                this.toolBar.add(btn);
                cursorToolGrp.add(btn);
            }
            if (this.toolSet.contains((Object)Tool.ZOOM)) {
                btn = new JButton(new ZoomInAction(this.mapPane));
                btn.setName(TOOLBAR_ZOOMIN_BUTTON_NAME);
                this.toolBar.add(btn);
                cursorToolGrp.add(btn);
                btn = new JButton(new ZoomOutAction(this.mapPane));
                btn.setName(TOOLBAR_ZOOMOUT_BUTTON_NAME);
                this.toolBar.add(btn);
                cursorToolGrp.add(btn);
                this.toolBar.addSeparator();
            }
            if (this.toolSet.contains((Object)Tool.PAN)) {
                btn = new JButton(new PanAction(this.mapPane));
                btn.setName(TOOLBAR_PAN_BUTTON_NAME);
                this.toolBar.add(btn);
                cursorToolGrp.add(btn);
                this.toolBar.addSeparator();
            }
            if (this.toolSet.contains((Object)Tool.INFO)) {
                btn = new JButton(new InfoAction(this.mapPane));
                btn.setName(TOOLBAR_INFO_BUTTON_NAME);
                this.toolBar.add(btn);
                this.toolBar.addSeparator();
            }
            if (this.toolSet.contains((Object)Tool.RESET)) {
                btn = new JButton(new ResetAction(this.mapPane));
                btn.setName(TOOLBAR_RESET_BUTTON_NAME);
                this.toolBar.add(btn);
            }
            panel.add((Component)this.toolBar, "grow");
        }
        if (this.showLayerTable) {
            this.mapLayerTable = new MapLayerTable(this.mapPane);
            this.mapLayerTable.setPreferredSize(new Dimension(200, -1));
            JSplitPane splitPane = new JSplitPane(1, false, this.mapLayerTable, this.mapPane);
            panel.add((Component)splitPane, "grow");
        } else {
            panel.add((Component)this.mapPane, "grow");
        }
        if (this.showStatusBar) {
            panel.add((Component)JMapStatusBar.createDefaultStatusBar(this.mapPane), "grow");
        }
        this.getContentPane().add(panel);
        this.uiSet = true;
    }

    public MapContent getMapContent() {
        return this.mapPane.getMapContent();
    }

    public void setMapContent(MapContent content) {
        if (content == null) {
            throw new IllegalArgumentException("map content must not be null");
        }
        this.mapPane.setMapContent(content);
    }

    public JMapPane getMapPane() {
        return this.mapPane;
    }

    public JToolBar getToolBar() {
        if (!this.uiSet) {
            this.initComponents();
        }
        return this.toolBar;
    }

    public static enum Tool {
        POINTER,
        INFO,
        PAN,
        RESET,
        ZOOM,
        SCROLLWHEEL;

    }
}

