/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.swing.tool;

import java.awt.Cursor;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.geom.Point2D;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import org.geotools.api.geometry.Bounds;
import org.geotools.geometry.Position2D;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.swing.event.MapMouseEvent;
import org.geotools.swing.locale.LocaleUtils;
import org.geotools.swing.tool.AbstractZoomTool;

public class ZoomOutTool
extends AbstractZoomTool {
    public static final String TOOL_NAME = LocaleUtils.getValue("CursorTool", "ZoomOut");
    public static final String TOOL_TIP = LocaleUtils.getValue("CursorTool", "ZoomOutTooltip");
    public static final String CURSOR_IMAGE = "/org/geotools/swing/icons/mActionZoomOut.png";
    public static final Point CURSOR_HOTSPOT = new Point(14, 9);
    public static final String ICON_IMAGE = "/org/geotools/swing/icons/mActionZoomOut.png";
    private Cursor cursor;

    public ZoomOutTool() {
        Toolkit tk = Toolkit.getDefaultToolkit();
        ImageIcon imgIcon = new ImageIcon(this.getClass().getResource("/org/geotools/swing/icons/mActionZoomOut.png"));
        this.cursor = tk.createCustomCursor(imgIcon.getImage(), CURSOR_HOTSPOT, TOOL_NAME);
    }

    @Override
    public void onMouseClicked(MapMouseEvent ev) {
        Rectangle paneArea = ((JComponent)((Object)this.getMapPane())).getVisibleRect();
        Position2D mapPos = ev.getWorldPos();
        double scale = this.getMapPane().getWorldToScreenTransform().getScaleX();
        double newScale = scale / this.zoom;
        Position2D corner = new Position2D(mapPos.getX() - 0.5 * paneArea.getWidth() / newScale, mapPos.getY() + 0.5 * paneArea.getHeight() / newScale);
        ReferencedEnvelope newMapArea = new ReferencedEnvelope();
        newMapArea.setFrameFromCenter((Point2D)mapPos, (Point2D)corner);
        this.getMapPane().setDisplayArea((Bounds)newMapArea);
    }

    @Override
    public Cursor getCursor() {
        return this.cursor;
    }

    @Override
    public boolean drawDragBox() {
        return false;
    }
}

