/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.swing.tool;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.geotools.api.feature.type.Name;

public class InfoToolResult {
    private final List<ResultItem> items = new ArrayList<ResultItem>();
    private ResultItem currentItem;

    public void newFeature(String id) {
        this.currentItem = new ResultItem(id);
        this.items.add(this.currentItem);
    }

    public void setFeatureValue(Name name, Object value) {
        if (this.currentItem == null) {
            throw new IllegalStateException("Missing prior call to newFeature method");
        }
        this.currentItem.put(name.toString(), value);
    }

    public void setFeatureValue(String name, Object value) {
        if (this.currentItem == null) {
            throw new IllegalStateException("Missing prior call to newFeature method");
        }
        this.currentItem.put(name, value);
    }

    public int getNumFeatures() {
        return this.items.size();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        int k = 0;
        for (ResultItem item : this.items) {
            sb.append(item.toString());
            if (++k >= this.items.size()) continue;
            sb.append('\n');
        }
        return sb.toString();
    }

    public Map<String, Object> getFeatureData(int featureIndex) {
        if (featureIndex < 0 || featureIndex >= this.getNumFeatures()) {
            throw new IndexOutOfBoundsException("Invalid index value: " + featureIndex);
        }
        return Collections.unmodifiableMap(this.items.get((int)featureIndex).data);
    }

    public String getFeatureId(int featureIndex) {
        if (featureIndex < 0 || featureIndex >= this.getNumFeatures()) {
            throw new IndexOutOfBoundsException("Invalid index value: " + featureIndex);
        }
        return this.items.get((int)featureIndex).id;
    }

    private static class ResultItem {
        String id;
        Map<String, Object> data;

        ResultItem(String id) {
            this.id = id;
            this.data = new LinkedHashMap<String, Object>();
        }

        boolean isEmpty() {
            return this.data.isEmpty();
        }

        void put(String name, Object value) {
            this.data.put(name, value);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            if (this.id != null) {
                sb.append(this.id).append("\n");
            }
            for (Map.Entry<String, Object> e : this.data.entrySet()) {
                sb.append(e.getKey()).append(": ").append(e.getValue()).append('\n');
            }
            return sb.toString();
        }
    }
}

