/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.swing.tool;

import java.awt.geom.AffineTransform;
import java.lang.ref.WeakReference;
import java.util.logging.Logger;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.api.referencing.operation.MathTransform;
import org.geotools.geometry.Position2D;
import org.geotools.map.Layer;
import org.geotools.map.MapBoundsEvent;
import org.geotools.map.MapBoundsListener;
import org.geotools.map.MapContent;
import org.geotools.referencing.CRS;
import org.geotools.referencing.operation.transform.AffineTransform2D;
import org.geotools.swing.tool.InfoToolResult;
import org.geotools.util.logging.Logging;

public abstract class InfoToolHelper
implements MapBoundsListener {
    private static final Logger LOGGER = Logging.getLogger(InfoToolHelper.class);
    public static final String KEY_POSITION = "pos";
    protected WeakReference<MapContent> contentRef;
    protected WeakReference<Layer> layerRef;
    private boolean transformFailed;
    private MathTransform transform;

    public abstract boolean isSupportedLayer(Layer var1);

    public abstract InfoToolResult getInfo(Position2D var1) throws Exception;

    public boolean isValid() {
        return this.contentRef != null && this.contentRef.get() != null && this.layerRef != null && this.layerRef.get() != null;
    }

    public void setMapContent(MapContent content) {
        if (content == null) {
            throw new IllegalArgumentException("content must not be null");
        }
        this.contentRef = new WeakReference<MapContent>(content);
        this.clearTransform();
    }

    public MapContent getMapContent() {
        return this.contentRef != null ? (MapContent)this.contentRef.get() : null;
    }

    public void setLayer(Layer layer) {
        if (layer == null) {
            throw new IllegalArgumentException("layer must not be null");
        }
        this.layerRef = new WeakReference<Layer>(layer);
        this.clearTransform();
    }

    public Layer getLayer() {
        return this.layerRef != null ? (Layer)this.layerRef.get() : null;
    }

    public void mapBoundsChanged(MapBoundsEvent event) {
        this.clearTransform();
    }

    protected MathTransform getContentToLayerTransform() {
        if (this.transform == null && !this.transformFailed) {
            MapContent content = this.getMapContent();
            Layer layer = this.getLayer();
            if (content != null && layer != null) {
                CoordinateReferenceSystem contentCRS = content.getCoordinateReferenceSystem();
                CoordinateReferenceSystem layerCRS = layer.getFeatureSource().getSchema().getCoordinateReferenceSystem();
                if (contentCRS != null && layerCRS != null) {
                    if (CRS.equalsIgnoreMetadata((Object)contentCRS, (Object)layerCRS)) {
                        this.transform = new AffineTransform2D(new AffineTransform());
                    } else {
                        try {
                            this.transform = CRS.findMathTransform((CoordinateReferenceSystem)contentCRS, (CoordinateReferenceSystem)layerCRS, (boolean)true);
                        }
                        catch (Exception ex) {
                            LOGGER.warning("Can't transform map content CRS to layer CRS");
                            this.transformFailed = true;
                        }
                    }
                }
            } else {
                this.transform = new AffineTransform2D(new AffineTransform());
            }
        }
        return this.transform;
    }

    protected boolean isTransformRequired() {
        return !this.getContentToLayerTransform().isIdentity();
    }

    protected void clearTransform() {
        this.transform = null;
        this.transformFailed = false;
    }
}

