/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.swing.tool;

import java.util.Collection;
import org.geotools.api.data.FeatureSource;
import org.geotools.api.data.Query;
import org.geotools.api.feature.Feature;
import org.geotools.api.feature.type.GeometryDescriptor;
import org.geotools.api.feature.type.Name;
import org.geotools.api.feature.type.PropertyDescriptor;
import org.geotools.api.filter.Filter;
import org.geotools.api.filter.FilterFactory;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.filter.spatial.Intersects;
import org.geotools.api.geometry.BoundingBox;
import org.geotools.api.geometry.Position;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.geometry.Position2D;
import org.geotools.geometry.jts.Geometries;
import org.geotools.geometry.jts.JTSFactoryFinder;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.map.FeatureLayer;
import org.geotools.map.Layer;
import org.geotools.swing.tool.InfoToolHelper;
import org.geotools.swing.tool.InfoToolResult;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.Point;

public class FeatureLayerHelper
extends InfoToolHelper {
    public static final double DEFAULT_DISTANCE_FRACTION = 0.01;
    private static final GeometryFactory geometryFactory = JTSFactoryFinder.getGeometryFactory(null);
    private static final FilterFactory filterFactory = CommonFactoryFinder.getFilterFactory(null);
    private String attrName;
    private Geometries geomType;

    @Override
    public void setLayer(Layer layer) {
        if (!(layer instanceof FeatureLayer)) {
            throw new IllegalArgumentException("layer must be an instance of FeatureLayer");
        }
        super.setLayer(layer);
        GeometryDescriptor geomDesc = layer.getFeatureSource().getSchema().getGeometryDescriptor();
        this.attrName = geomDesc.getLocalName();
        Class geomClass = geomDesc.getType().getBinding();
        this.geomType = Geometries.getForBinding((Class)geomClass);
    }

    @Override
    public boolean isSupportedLayer(Layer layer) {
        return layer instanceof FeatureLayer;
    }

    @Override
    public InfoToolResult getInfo(Position2D pos) throws Exception {
        InfoToolResult result = new InfoToolResult();
        if (this.isValid()) {
            Intersects filter = null;
            if (this.geomType == Geometries.POLYGON || this.geomType == Geometries.MULTIPOLYGON) {
                Geometry posGeom = this.createSearchPoint(pos);
                filter = filterFactory.intersects((Expression)filterFactory.property(this.attrName), (Expression)filterFactory.literal((Object)posGeom));
            } else {
                ReferencedEnvelope env = this.createSearchEnv(pos);
                filter = filterFactory.bbox((Expression)filterFactory.property(this.attrName), (BoundingBox)env);
            }
            Query query = new Query(null, (Filter)filter);
            query.setCoordinateSystemReproject(this.getMapContent().getCoordinateReferenceSystem());
            FeatureSource featureSource = this.getLayer().getFeatureSource();
            Collection descriptors = featureSource.getSchema().getDescriptors();
            FeatureCollection queryResult = featureSource.getFeatures(query);
            try (FeatureIterator iter = queryResult.features();){
                while (iter.hasNext()) {
                    Feature f = iter.next();
                    result.newFeature(f.getIdentifier().getID());
                    for (PropertyDescriptor desc : descriptors) {
                        Name name = desc.getName();
                        Object value = f.getProperty(name).getValue();
                        if (value != null) {
                            if (value instanceof Geometry) {
                                result.setFeatureValue(name, (Object)value.getClass().getSimpleName());
                                continue;
                            }
                            result.setFeatureValue(name, value);
                            continue;
                        }
                        result.setFeatureValue(name, (Object)"null");
                    }
                }
            }
        }
        return result;
    }

    private Geometry createSearchPoint(Position2D pos) {
        try {
            Position2D trPos = new Position2D();
            this.getContentToLayerTransform().transform((Position)pos, (Position)trPos);
            Point point = geometryFactory.createPoint(new Coordinate(trPos.x, trPos.y));
            return point;
        }
        catch (Exception ex) {
            throw new IllegalStateException(ex);
        }
    }

    private ReferencedEnvelope createSearchEnv(Position2D pos) {
        ReferencedEnvelope mapBounds = this.getMapContent().getViewport().getBounds();
        if (mapBounds == null || mapBounds.isEmpty()) {
            Layer layer = this.getLayer();
            if (layer == null) {
                throw new IllegalStateException("Target layer has been lost");
            }
            mapBounds = this.getLayer().getBounds();
        }
        double halfWidth = 0.005 * (mapBounds.getWidth() + mapBounds.getHeight());
        CoordinateReferenceSystem contentCRS = this.getMapContent().getCoordinateReferenceSystem();
        ReferencedEnvelope env = new ReferencedEnvelope(pos.x - halfWidth, pos.x + halfWidth, pos.y - halfWidth, pos.y + halfWidth, contentCRS);
        if (this.isTransformRequired()) {
            CoordinateReferenceSystem layerCRS = this.getLayer().getFeatureSource().getSchema().getCoordinateReferenceSystem();
            try {
                env = env.transform(layerCRS, true);
            }
            catch (Exception ex) {
                throw new IllegalStateException(ex);
            }
        }
        return env;
    }
}

