/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.swing.event;

import java.awt.Component;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.geotools.geometry.Position2D;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.swing.MapPane;

public final class MapMouseEvent
extends MouseEvent {
    private final Position2D worldCoords;
    private final boolean isWheelEvent;
    private final int wheelAmount;

    public MapMouseEvent(MapPane pane, MouseEvent event) {
        super((Component)((Object)pane), event.getID(), event.getWhen(), event.getModifiers(), event.getX(), event.getY(), event.getClickCount(), event.isPopupTrigger(), event.getButton());
        this.worldCoords = this.calculateWorldPos(pane, event);
        this.isWheelEvent = false;
        this.wheelAmount = 0;
    }

    public MapMouseEvent(MapPane pane, MouseWheelEvent event) {
        super((Component)((Object)pane), event.getID(), event.getWhen(), event.getModifiers(), event.getX(), event.getY(), event.getClickCount(), event.isPopupTrigger());
        this.worldCoords = this.calculateWorldPos(pane, event);
        this.isWheelEvent = true;
        this.wheelAmount = event.getWheelRotation();
    }

    @Override
    public MapPane getSource() {
        return (MapPane)super.getSource();
    }

    public boolean isWheelEvent() {
        return this.isWheelEvent;
    }

    public int getWheelAmount() {
        return this.wheelAmount;
    }

    public Position2D getWorldPos() {
        return new Position2D(this.worldCoords.getCoordinateReferenceSystem(), this.worldCoords.x, this.worldCoords.y);
    }

    public ReferencedEnvelope getEnvelopeByWorld(double widthWorld) {
        if (widthWorld < 0.0) {
            throw new IllegalArgumentException("invalid value for widthWorld: " + widthWorld);
        }
        double halfw = widthWorld / 2.0;
        Position2D worldPos = this.getWorldPos();
        return new ReferencedEnvelope(worldPos.x - halfw, worldPos.x + halfw, worldPos.y - halfw, worldPos.y + halfw, worldPos.getCoordinateReferenceSystem());
    }

    public ReferencedEnvelope getEnvelopeByPixels(double widthPixels) {
        if (widthPixels < 0.0) {
            throw new IllegalArgumentException("invalid value for widthPixels: " + widthPixels);
        }
        Rectangle2D.Double screenRect = new Rectangle2D.Double((double)this.getX() - widthPixels / 2.0, (double)this.getY() - widthPixels / 2.0, widthPixels, widthPixels);
        MapPane pane = this.getSource();
        Rectangle2D worldRect = pane.getScreenToWorldTransform().createTransformedShape(screenRect).getBounds2D();
        return new ReferencedEnvelope(worldRect, pane.getMapContent().getCoordinateReferenceSystem());
    }

    private Position2D calculateWorldPos(MapPane pane, MouseEvent event) {
        AffineTransform tr = pane.getScreenToWorldTransform();
        Position2D pos = new Position2D((double)event.getX(), (double)event.getY());
        tr.transform((Point2D)pos, (Point2D)pos);
        pos.setCoordinateReferenceSystem(pane.getMapContent().getCoordinateReferenceSystem());
        return pos;
    }
}

