/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.swing.dialog;

import java.awt.Component;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.EnumSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;
import org.geotools.util.logging.Logging;

public class JFileImageChooser
extends JFileChooser {
    private static final Logger LOGGER = Logging.getLogger(JFileImageChooser.class);
    private static final EnumSet<FormatSpecifier> supportedReaders = EnumSet.noneOf(FormatSpecifier.class);
    private static final EnumSet<FormatSpecifier> supportedWriters = EnumSet.noneOf(FormatSpecifier.class);

    public static File showSaveFile() {
        return JFileImageChooser.showSaveFile(null);
    }

    public static File showSaveFile(Component parent) {
        return JFileImageChooser.showSaveFile(parent, null);
    }

    public static File showSaveFile(Component parent, File workingDir) {
        File[] file = new File[1];
        if (SwingUtilities.isEventDispatchThread()) {
            file[0] = JFileImageChooser.doShow(parent, workingDir, 1);
        } else {
            try {
                SwingUtilities.invokeAndWait(() -> {
                    file[0] = JFileImageChooser.doShow(parent, workingDir, 1);
                });
            }
            catch (InterruptedException ex) {
                LOGGER.log(Level.SEVERE, "Thread interrupted while prompting for file", ex);
            }
            catch (InvocationTargetException ex) {
                LOGGER.log(Level.SEVERE, "Unexpected problem while prompting for file", ex);
            }
        }
        return file[0];
    }

    public static File showOpenFile() {
        return JFileImageChooser.showOpenFile(null, null);
    }

    public static File showOpenFile(Component parent) {
        return JFileImageChooser.showOpenFile(parent, null);
    }

    public static File showOpenFile(Component parent, File workingDir) {
        File[] file = new File[1];
        if (SwingUtilities.isEventDispatchThread()) {
            file[0] = JFileImageChooser.doShow(parent, workingDir, 0);
        } else {
            try {
                SwingUtilities.invokeAndWait(() -> {
                    file[0] = JFileImageChooser.doShow(parent, workingDir, 0);
                });
            }
            catch (InterruptedException ex) {
                LOGGER.log(Level.SEVERE, "Thread interrupted while prompting for file", ex);
            }
            catch (InvocationTargetException ex) {
                LOGGER.log(Level.SEVERE, "Unexpected problem while prompting for file", ex);
            }
        }
        return file[0];
    }

    private static File doShow(Component parent, File workingDir, int openOrSave) {
        int dialogRtnValue;
        JFileImageChooser chooser = new JFileImageChooser(workingDir);
        File file = null;
        switch (openOrSave) {
            case 0: {
                chooser.setFilter(supportedReaders);
                chooser.setDialogTitle("Open image");
                dialogRtnValue = chooser.showOpenDialog(parent);
                break;
            }
            case 1: {
                chooser.setFilter(supportedWriters);
                chooser.setDialogTitle("Save image");
                dialogRtnValue = chooser.showSaveDialog(parent);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid value for openOrSave argument" + openOrSave);
            }
        }
        if (dialogRtnValue == 0) {
            file = chooser.getSelectedFile();
            Object name = file.getAbsolutePath();
            int dot = ((String)name).lastIndexOf(46);
            FormatFilter filter = (FormatFilter)chooser.getFileFilter();
            if (dot < 0) {
                name = (String)name + filter.getDefaultSuffix();
                file = new File((String)name);
            }
        }
        return file;
    }

    private JFileImageChooser(File workingDir) {
        super(workingDir);
    }

    @Override
    public void approveSelection() {
        FormatFilter filter = (FormatFilter)this.getFileFilter();
        File file = this.getSelectedFile();
        Object name = file.getAbsolutePath();
        int dot = ((String)name).lastIndexOf(46);
        boolean ok = true;
        if (dot < 0) {
            name = (String)name + filter.getDefaultSuffix();
            file = new File((String)name);
            this.setSelectedFile(file);
        }
        if (this.getDialogType() == 1) {
            if (!filter.accept(this.getSelectedFile())) {
                StringBuilder sb = new StringBuilder();
                sb.append("'");
                sb.append(((String)name).substring(dot + 1));
                sb.append("' ");
                sb.append("is not a standard suffix for a ");
                sb.append(filter.getDescription());
                sb.append(".");
                sb.append("\nDo you want to save with this name ?");
                int answer = JOptionPane.showConfirmDialog(this.getParent(), sb.toString(), "Confirm file name", 0);
                boolean bl = ok = answer == 0;
            }
            if (ok && file.exists()) {
                int answer = JOptionPane.showConfirmDialog(this, "Overwrite the existing file ?", "File exists", 0);
                ok = answer == 0;
            }
        } else if (!file.exists()) {
            JOptionPane.showMessageDialog(this, "Can't file this file", "File not found", 2);
            ok = false;
        }
        if (ok) {
            super.approveSelection();
        }
    }

    private void setFilter(Set<FormatSpecifier> supportedFormats) {
        this.setAcceptAllFileFilterUsed(false);
        for (FormatSpecifier format : supportedFormats) {
            this.addChoosableFileFilter(new FormatFilter(format));
        }
    }

    static {
        for (FormatSpecifier format : FormatSpecifier.values()) {
            if (ImageIO.getImageReadersBySuffix(format.id).hasNext()) {
                supportedReaders.add(format);
            }
            if (!ImageIO.getImageWritersBySuffix(format.id).hasNext()) continue;
            supportedWriters.add(format);
        }
    }

    static class FormatFilter
    extends FileFilter {
        private FormatSpecifier format;

        public FormatFilter(FormatSpecifier format) {
            this.format = format;
        }

        @Override
        public boolean accept(File f) {
            if (f.isDirectory()) {
                return true;
            }
            for (String suffix : this.format.suffixes) {
                if (!f.getPath().endsWith(suffix) && !f.getPath().endsWith(suffix.toUpperCase())) continue;
                return true;
            }
            return false;
        }

        @Override
        public String getDescription() {
            return this.format.desc;
        }

        public String getDefaultSuffix() {
            return this.format.suffixes[0];
        }
    }

    private static enum FormatSpecifier {
        BMP("bmp", "BMP image", ".bmp"),
        GIF("gif", "GIF image", ".gif"),
        JPG("jpg", "JPEG image", ".jpg", ".jpeg"),
        PNG("png", "PNG image", "png"),
        TIF("tif", "TIFF image", ".tif", ".tiff");

        private String id;
        private String desc;
        private String[] suffixes;

        private FormatSpecifier(String id, String desc, String ... suffixes) {
            this.id = id;
            this.desc = desc;
            this.suffixes = new String[suffixes.length];
            System.arraycopy(suffixes, 0, this.suffixes, 0, suffixes.length);
        }
    }
}

