/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.swing.data;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.geotools.api.data.Parameter;
import org.geotools.swing.data.JParameterListPage;
import org.geotools.swing.wizard.JWizard;
import org.geotools.util.URLs;

public class JParameterListWizard
extends JWizard {
    private static final long serialVersionUID = -3961250234483352643L;
    private JParameterListPage userPage;
    private JParameterListPage advancedPage;
    protected Map<String, Object> connectionParameters;

    public JParameterListWizard(String title, String description, List<Parameter<?>> contents, Map<String, Object> connectionParams) {
        super(title);
        this.connectionParameters = connectionParams == null ? new HashMap() : connectionParams;
        this.fillInDefaults(contents, this.connectionParameters);
        List<Parameter<?>> userContents = this.contentsForLevel(contents, "user");
        this.userPage = new JParameterListPage(title, description, userContents, this.connectionParameters);
        this.userPage.setPageIdentifier("userPage");
        this.registerWizardPanel(this.userPage);
        List<Parameter<?>> advancedContents = this.contentsForLevel(contents, "advanced");
        if (!advancedContents.isEmpty()) {
            this.advancedPage = new JParameterListPage(title, description, advancedContents, this.connectionParameters);
            this.advancedPage.setPageIdentifier("advancedPage");
            this.advancedPage.setBackPageIdentifier("userPage");
            this.registerWizardPanel(this.advancedPage);
            this.userPage.setNextPageIdentifier("advancedPage");
        }
        this.setCurrentPanel("userPage");
    }

    public JParameterListWizard(String title, String description, List<Parameter<?>> contents) {
        this(title, description, contents, new HashMap<String, Object>());
    }

    private void fillInDefaults(List<Parameter<?>> contents, Map<String, Object> connectionParams) {
        if (connectionParams == null) {
            return;
        }
        for (Parameter<?> param : contents) {
            if (!param.required || !"program".equals(param.getLevel()) || connectionParams.containsKey(param.key)) continue;
            connectionParams.put(param.key, param.sample);
        }
    }

    List<Parameter<?>> contentsForLevel(List<Parameter<?>> contents, String level) {
        ArrayList list = new ArrayList();
        if (level == null) {
            level = "user";
        }
        if (contents != null) {
            for (Parameter<?> param : contents) {
                String check;
                if (level == null) continue;
                String string = check = param.metadata == null ? "user" : (String)param.metadata.get("level");
                if (check == null) {
                    check = "user";
                }
                if (!level.equals(check)) continue;
                list.add(param);
            }
        }
        return list;
    }

    public Map<String, Object> getConnectionParameters() {
        return this.connectionParameters;
    }

    public File getFile() {
        URL url = (URL)this.connectionParameters.get("url");
        return URLs.urlToFile((URL)url);
    }
}

