/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.swing.control;

import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.util.List;
import javax.swing.JList;
import javax.swing.ListModel;
import org.geotools.swing.control.DnDListItemsTransferable;
import org.geotools.swing.control.DnDListModel;

public class DnDList<T>
extends JList<T>
implements DragGestureListener,
DragSourceListener,
DropTargetListener {
    private static final long serialVersionUID = 3310751294076288683L;
    private DragSource src;
    private DropTarget tgt;
    private boolean movingItems;
    private int overIndex;
    private int[] dragIndices;

    public DnDList() {
        this(new DnDListModel());
    }

    public DnDList(DnDListModel<T> model) {
        super(model);
        if (model == null) {
            throw new IllegalArgumentException("model must not be null");
        }
        this.src = new DragSource();
        this.src.createDefaultDragGestureRecognizer(this, 2, this);
        this.tgt = new DropTarget(this, this);
        this.movingItems = false;
        this.overIndex = -1;
    }

    @Override
    public DnDListModel<T> getModel() {
        return (DnDListModel)super.getModel();
    }

    @Override
    public void dragGestureRecognized(DragGestureEvent dge) {
        this.dragIndices = this.getSelectedIndices();
        if (this.dragIndices.length > 0) {
            List items = ((DnDListModel)this.getModel()).getElementsAt(this.dragIndices);
            DnDListItemsTransferable stuff = new DnDListItemsTransferable(items);
            this.movingItems = true;
            this.src.startDrag(dge, DragSource.DefaultMoveDrop, stuff, this);
        }
    }

    @Override
    public void dragEnter(DragSourceDragEvent dsde) {
    }

    @Override
    public void dragOver(DragSourceDragEvent dsde) {
    }

    @Override
    public void dropActionChanged(DragSourceDragEvent dsde) {
    }

    @Override
    public void dragExit(DragSourceEvent dse) {
    }

    @Override
    public void dragDropEnd(DragSourceDropEvent dsde) {
        this.movingItems = false;
        this.overIndex = -1;
    }

    @Override
    public void dragEnter(DropTargetDragEvent dtde) {
        this.overIndex = this.locationToIndex(dtde.getLocation());
        this.setSelectedIndex(this.overIndex);
    }

    @Override
    public void dragOver(DropTargetDragEvent dtde) {
        int index = this.locationToIndex(dtde.getLocation());
        if (index >= 0 && index != this.overIndex) {
            this.overIndex = index;
            this.setSelectedIndex(this.overIndex);
        }
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dtde) {
    }

    @Override
    public void dragExit(DropTargetEvent dte) {
        this.overIndex = -1;
    }

    @Override
    public void drop(DropTargetDropEvent dtde) {
        dtde.acceptDrop(2);
        if (this.movingItems) {
            ListModel model = this.getModel();
            ((DnDListModel)model).moveItems(this.overIndex, this.dragIndices);
        }
        this.overIndex = -1;
        this.movingItems = false;
        dtde.getDropTargetContext().dropComplete(true);
    }
}

