/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.swing;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.util.HashMap;
import org.geotools.map.MapContent;
import org.geotools.renderer.GTRenderer;
import org.geotools.renderer.label.LabelCacheImpl;
import org.geotools.renderer.lite.LabelCache;
import org.geotools.renderer.lite.StreamingRenderer;
import org.geotools.swing.AbstractMapPane;
import org.geotools.swing.RenderingExecutor;

public class JMapPane
extends AbstractMapPane {
    private GTRenderer renderer;
    protected BufferedImage baseImage;
    private Graphics2D baseImageGraphics;

    public JMapPane() {
        this((MapContent)null);
    }

    public JMapPane(MapContent content) {
        this(content, null, null);
    }

    public JMapPane(MapContent content, RenderingExecutor executor, GTRenderer renderer) {
        super(content, executor);
        this.doSetRenderer(renderer);
    }

    @Override
    public void setMapContent(MapContent content) {
        super.setMapContent(content);
        if (content != null && this.renderer != null && this.renderer.getMapContent() != content) {
            this.renderer.setMapContent(this.mapContent);
        }
    }

    public GTRenderer getRenderer() {
        if (this.renderer == null) {
            this.doSetRenderer((GTRenderer)new StreamingRenderer());
        }
        return this.renderer;
    }

    public void setRenderer(GTRenderer renderer) {
        this.doSetRenderer(renderer);
    }

    private void doSetRenderer(GTRenderer newRenderer) {
        if (newRenderer != null) {
            HashMap<String, LabelCache> hints = newRenderer.getRendererHints();
            if (hints == null) {
                hints = new HashMap<String, LabelCache>();
            }
            if (newRenderer instanceof StreamingRenderer) {
                if (hints.containsKey("labelCache")) {
                    this.labelCache = (LabelCache)hints.get("labelCache");
                } else {
                    this.labelCache = new LabelCacheImpl();
                    hints.put("labelCache", this.labelCache);
                }
            }
            newRenderer.setRendererHints(hints);
            if (this.mapContent != null) {
                newRenderer.setMapContent(this.mapContent);
            }
        }
        this.renderer = newRenderer;
    }

    public RenderedImage getBaseImage() {
        return this.baseImage;
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.drawingLock.tryLock()) {
            try {
                if (this.baseImage != null) {
                    Graphics2D g2 = (Graphics2D)g;
                    g2.drawImage((Image)this.baseImage, this.imageOrigin.x, this.imageOrigin.y, null);
                }
            }
            finally {
                this.drawingLock.unlock();
            }
        }
    }

    @Override
    protected void drawLayers(boolean createNewImage) {
        this.drawingLock.lock();
        try {
            if (this.mapContent != null && !this.mapContent.getViewport().isEmpty() && this.acceptRepaintRequests.get()) {
                Rectangle r = this.getVisibleRect();
                if (this.baseImage == null || createNewImage) {
                    this.baseImage = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration().createCompatibleImage(r.width, r.height, 3);
                    if (this.baseImageGraphics != null) {
                        this.baseImageGraphics.dispose();
                    }
                    this.baseImageGraphics = this.baseImage.createGraphics();
                    this.baseImageGraphics.setBackground(this.getBackground());
                    this.baseImageGraphics.clearRect(0, 0, r.width, r.height);
                    this.clearLabelCache.set(true);
                } else {
                    this.baseImageGraphics.setBackground(this.getBackground());
                    this.baseImageGraphics.clearRect(0, 0, r.width, r.height);
                }
                if (this.mapContent != null && !this.mapContent.layers().isEmpty()) {
                    this.getRenderingExecutor().submit(this.mapContent, this.getRenderer(), this.baseImageGraphics, this);
                }
            }
        }
        finally {
            this.drawingLock.unlock();
        }
    }
}

