/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.swing.tool;

import java.awt.Cursor;
import java.awt.Point;
import java.awt.Toolkit;
import javax.swing.ImageIcon;
import org.geotools.swing.event.MapMouseEvent;
import org.geotools.swing.locale.LocaleUtils;
import org.geotools.swing.tool.CursorTool;

public class PanTool
extends CursorTool {
    public static final String TOOL_NAME = LocaleUtils.getValue("CursorTool", "Pan");
    public static final String TOOL_TIP = LocaleUtils.getValue("CursorTool", "PanTooltip");
    public static final String CURSOR_IMAGE = "/org/geotools/swing/icons/mActionPan.png";
    public static final Point CURSOR_HOTSPOT = new Point(15, 15);
    public static final String ICON_IMAGE = "/org/geotools/swing/icons/mActionPan.png";
    private Cursor cursor;
    private Point panePos;
    boolean panning;

    public PanTool() {
        Toolkit tk = Toolkit.getDefaultToolkit();
        ImageIcon imgIcon = new ImageIcon(this.getClass().getResource("/org/geotools/swing/icons/mActionPan.png"));
        this.cursor = tk.createCustomCursor(imgIcon.getImage(), CURSOR_HOTSPOT, TOOL_NAME);
        this.panning = false;
    }

    @Override
    public void onMousePressed(MapMouseEvent ev) {
        this.panePos = ev.getPoint();
        this.panning = true;
    }

    @Override
    public void onMouseDragged(MapMouseEvent ev) {
        Point pos;
        if (this.panning && !(pos = ev.getPoint()).equals(this.panePos)) {
            this.getMapPane().moveImage(pos.x - this.panePos.x, pos.y - this.panePos.y);
            this.panePos = pos;
        }
    }

    @Override
    public void onMouseReleased(MapMouseEvent ev) {
        this.panning = false;
    }

    @Override
    public Cursor getCursor() {
        return this.cursor;
    }

    @Override
    public boolean drawDragBox() {
        return false;
    }
}

