/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.swing.dialog;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Toolkit;
import java.awt.Window;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import javax.swing.text.View;

public class DialogUtils {
    public static void showCentred(Window dialog) {
        DialogUtils.showCentredOnParent(null, dialog);
    }

    public static void showCentredOnParent(final Window parent, final Window dialog) {
        if (EventQueue.isDispatchThread()) {
            DialogUtils.doShowCentred(parent, dialog);
        } else {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    DialogUtils.doShowCentred(parent, dialog);
                }
            });
        }
    }

    public static <T extends JComponent> List<T> getChildComponents(Class<T> clazz, Container parent, boolean includeNested) {
        ArrayList<JComponent> children = new ArrayList<JComponent>();
        for (Component c : parent.getComponents()) {
            boolean isClazz = clazz.isAssignableFrom(c.getClass());
            if (isClazz) {
                children.add((JComponent)clazz.cast(c));
            }
            if (!includeNested || !(c instanceof Container)) continue;
            children.addAll(DialogUtils.getChildComponents(clazz, (Container)c, includeNested));
        }
        return children;
    }

    public static String getString(String input, String fallback) {
        if (input == null || input.trim().length() == 0) {
            return fallback;
        }
        return input;
    }

    private static void doShowCentred(Window parent, Window dialog) {
        if (parent == null) {
            DialogUtils.doCentre(dialog, Toolkit.getDefaultToolkit().getScreenSize());
        } else {
            DialogUtils.doCentre(dialog, parent.getSize());
        }
        dialog.setVisible(true);
    }

    private static void doCentre(Window dialog, Dimension parentDim) {
        Dimension dialogDim = dialog.getSize();
        int x = Math.max(0, parentDim.width / 2 - dialogDim.width / 2);
        int y = Math.max(0, parentDim.height / 2 - dialogDim.height / 2);
        dialog.setLocation(x, y);
    }

    public static Dimension getHtmlLabelTextExtent(final String labelText, final int fixedDimSize, final boolean width) {
        final Dimension[] result = new Dimension[1];
        if (SwingUtilities.isEventDispatchThread()) {
            result[0] = DialogUtils.doGetHtmlTextExtent(labelText, fixedDimSize, width);
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        result[0] = DialogUtils.doGetHtmlTextExtent(labelText, fixedDimSize, width);
                    }
                });
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
        return result[0];
    }

    private static Dimension doGetHtmlTextExtent(String labelText, int fixedDimSize, boolean width) {
        JLabel label = new JLabel();
        if (labelText.startsWith("<html>")) {
            label.setText(labelText);
        } else {
            label.setText("<html>" + labelText + "</html>");
        }
        View view = (View)label.getClientProperty("html");
        view.setSize(width ? (float)fixedDimSize : 0.0f, width ? 0.0f : (float)fixedDimSize);
        float w = view.getPreferredSpan(0);
        float h = view.getPreferredSpan(1);
        return new Dimension((int)Math.ceil(w), (int)Math.ceil(h));
    }
}

