/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.swing.styling;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.util.HashMap;
import java.util.Map;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.MutableComboBoxModel;
import net.miginfocom.swing.MigLayout;
import org.geotools.data.DataStore;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.geometry.jts.Geometries;
import org.geotools.map.RasterLayer;
import org.geotools.map.StyleLayer;
import org.geotools.styling.FeatureTypeStyle;
import org.geotools.styling.Fill;
import org.geotools.styling.Font;
import org.geotools.styling.LineSymbolizer;
import org.geotools.styling.PointSymbolizer;
import org.geotools.styling.PolygonSymbolizer;
import org.geotools.styling.Rule;
import org.geotools.styling.SLD;
import org.geotools.styling.Stroke;
import org.geotools.styling.Style;
import org.geotools.styling.StyleFactory;
import org.geotools.styling.Symbolizer;
import org.geotools.swing.styling.JColorIcon;
import org.geotools.swing.styling.JFontChooser;
import org.locationtech.jts.geom.Geometry;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.GeometryDescriptor;

public class JSimpleStyleDialog
extends JDialog {
    private static StyleFactory sf = CommonFactoryFinder.getStyleFactory(null);
    private static final String[] WELL_KNOWN_SYMBOL_NAMES = new String[]{"Circle", "Square", "Cross", "X", "Triangle", "Star"};
    public static final Color DEFAULT_LINE_COLOR = Color.BLACK;
    public static final Color DEFAULT_FILL_COLOR = Color.WHITE;
    public static final float DEFAULT_LINE_WIDTH = 1.0f;
    public static final float DEFAULT_OPACITY = 1.0f;
    public static final float DEFAULT_POINT_SIZE = 3.0f;
    public static final String DEFAULT_POINT_SYMBOL_NAME = "Circle";
    private static int COLOR_ICON_SIZE = 16;
    private Geometries geomType;
    private Color lineColor;
    private Color fillColor;
    private float lineWidth;
    private float opacity;
    private float pointSize;
    private String pointSymbolName;
    private boolean labelFeatures;
    private String labelField;
    private Font labelFont;
    private JColorIcon lineColorIcon;
    private JLabel lineColorLabel;
    private JColorIcon fillColorIcon;
    private JLabel fillColorLabel;
    private JSlider fillOpacitySlider;
    private JComboBox<Number> pointSizeCBox;
    private JComboBox<String> pointSymbolCBox;
    private JLabel typeLabel;
    private JComboBox<String> labelCBox;
    private Map<Component, ControlCategory> controls;
    private final SimpleFeatureType schema;
    private String[] fieldsForLabels;
    private boolean completed;

    public static Style showDialog(Component parent, StyleLayer layer) {
        if (layer instanceof RasterLayer) {
            JOptionPane.showMessageDialog(null, "Sorry, styling for for grid coverages is not working yet", "Style dialog", 2);
            return null;
        }
        SimpleFeatureType type = (SimpleFeatureType)layer.getFeatureSource().getSchema();
        return JSimpleStyleDialog.showDialog(parent, type, layer.getStyle());
    }

    public static Style showDialog(Component parent, DataStore dataStore) {
        return JSimpleStyleDialog.showDialog(parent, dataStore, null);
    }

    public static Style showDialog(Component parent, DataStore dataStore, Style initialStyle) {
        SimpleFeatureType type = null;
        try {
            String typeName = dataStore.getTypeNames()[0];
            type = dataStore.getSchema(typeName);
        }
        catch (Exception ex) {
            throw new IllegalStateException(ex);
        }
        return JSimpleStyleDialog.showDialog(parent, type, initialStyle);
    }

    public static Style showDialog(Component parent, SimpleFeatureType featureType) {
        return JSimpleStyleDialog.showDialog(parent, featureType, null);
    }

    public static Style showDialog(Component parent, SimpleFeatureType featureType, Style initialStyle) {
        Style style = null;
        Dialog dialog = null;
        if (parent != null) {
            if (parent instanceof Frame) {
                dialog = new JSimpleStyleDialog((Frame)parent, featureType, initialStyle);
            } else if (parent instanceof Dialog) {
                dialog = new JSimpleStyleDialog((Dialog)parent, featureType, initialStyle);
            }
        }
        if (dialog == null) {
            dialog = new JSimpleStyleDialog((Frame)null, featureType, initialStyle);
        }
        dialog.setVisible(true);
        if (((JSimpleStyleDialog)dialog).completed()) {
            switch (((JSimpleStyleDialog)dialog).getGeomType()) {
                case POLYGON: 
                case MULTIPOLYGON: {
                    style = SLD.createPolygonStyle((Color)((JSimpleStyleDialog)dialog).getLineColor(), (Color)((JSimpleStyleDialog)dialog).getFillColor(), (float)((JSimpleStyleDialog)dialog).getOpacity(), (String)((JSimpleStyleDialog)dialog).getLabelField(), (Font)((JSimpleStyleDialog)dialog).getLabelFont());
                    break;
                }
                case LINESTRING: 
                case MULTILINESTRING: {
                    style = SLD.createLineStyle((Color)((JSimpleStyleDialog)dialog).getLineColor(), (float)((JSimpleStyleDialog)dialog).getLineWidth(), (String)((JSimpleStyleDialog)dialog).getLabelField(), (Font)((JSimpleStyleDialog)dialog).getLabelFont());
                    break;
                }
                case POINT: 
                case MULTIPOINT: {
                    style = SLD.createPointStyle((String)((JSimpleStyleDialog)dialog).getPointSymbolName(), (Color)((JSimpleStyleDialog)dialog).getLineColor(), (Color)((JSimpleStyleDialog)dialog).getFillColor(), (float)((JSimpleStyleDialog)dialog).getOpacity(), (float)((JSimpleStyleDialog)dialog).getPointSize(), (String)((JSimpleStyleDialog)dialog).getLabelField(), (Font)((JSimpleStyleDialog)dialog).getLabelFont());
                }
            }
        }
        dialog.dispose();
        return style;
    }

    public JSimpleStyleDialog(Frame owner, SimpleFeatureType schema, Style initialStyle) {
        super(owner, "Simple style maker", true);
        this.setResizable(false);
        this.schema = schema;
        this.init(initialStyle);
    }

    public JSimpleStyleDialog(Dialog owner, SimpleFeatureType schema, Style initialStyle) {
        super(owner, "Simple style maker", true);
        this.setResizable(false);
        this.schema = schema;
        this.init(initialStyle);
    }

    private void init(Style initialStyle) {
        this.lineColor = DEFAULT_LINE_COLOR;
        this.fillColor = DEFAULT_FILL_COLOR;
        this.lineWidth = 1.0f;
        this.opacity = 1.0f;
        this.pointSize = 3.0f;
        this.pointSymbolName = DEFAULT_POINT_SYMBOL_NAME;
        this.labelFeatures = false;
        this.labelField = null;
        this.labelFont = sf.getDefaultFont();
        this.geomType = null;
        this.completed = false;
        try {
            this.initComponents();
            this.setType();
            this.setStyle(initialStyle);
        }
        catch (Exception ex) {
            throw new IllegalStateException(ex);
        }
    }

    public boolean completed() {
        return this.completed;
    }

    public Geometries getGeomType() {
        return this.geomType;
    }

    public Color getLineColor() {
        return this.lineColor;
    }

    public Color getFillColor() {
        return this.fillColor;
    }

    @Override
    public float getOpacity() {
        return this.opacity;
    }

    public float getLineWidth() {
        return this.lineWidth;
    }

    public float getPointSize() {
        return this.pointSize;
    }

    public String getPointSymbolName() {
        return this.pointSymbolName;
    }

    public String getLabelField() {
        if (this.labelFeatures) {
            return this.labelField;
        }
        return null;
    }

    public Font getLabelFont() {
        return this.labelFont;
    }

    private void initComponents() {
        MigLayout layout = new MigLayout();
        JPanel panel = new JPanel((LayoutManager)layout);
        this.controls = new HashMap<Component, ControlCategory>();
        JLabel label = new JLabel("Feature type");
        label.setForeground(Color.BLUE);
        panel.add((Component)label, "wrap");
        this.typeLabel = new JLabel();
        panel.add((Component)this.typeLabel, "gapbefore indent, span, wrap");
        label = new JLabel("Line");
        label.setForeground(Color.BLUE);
        panel.add((Component)label, "wrap");
        JButton btn = new JButton("Color...");
        btn.addActionListener(e -> this.chooseLineColor());
        panel.add((Component)btn, "gapbefore indent");
        this.controls.put(btn, ControlCategory.LINE);
        this.lineColorIcon = new JColorIcon(COLOR_ICON_SIZE, COLOR_ICON_SIZE, DEFAULT_LINE_COLOR);
        this.lineColorLabel = new JLabel(this.lineColorIcon);
        panel.add((Component)this.lineColorLabel, "gapafter 20px");
        label = new JLabel("Width");
        panel.add((Component)label, "split 2");
        Integer[] widths = new Integer[5];
        for (int i = 1; i <= widths.length; ++i) {
            widths[i - 1] = i;
        }
        JComboBox<Integer> lineWidthCBox = new JComboBox<Integer>(widths);
        lineWidthCBox.addActionListener(e -> {
            this.lineWidth = ((Number)lineWidthCBox.getModel().getSelectedItem()).intValue();
        });
        panel.add(lineWidthCBox, "wrap");
        this.controls.put(lineWidthCBox, ControlCategory.LINE);
        label = new JLabel("Fill");
        label.setForeground(Color.BLUE);
        panel.add((Component)label, "wrap");
        btn = new JButton("Color...");
        btn.addActionListener(e -> this.chooseFillColor());
        panel.add((Component)btn, "gapbefore indent");
        this.controls.put(btn, ControlCategory.FILL);
        this.fillColorIcon = new JColorIcon(COLOR_ICON_SIZE, COLOR_ICON_SIZE, DEFAULT_FILL_COLOR);
        this.fillColorLabel = new JLabel(this.fillColorIcon);
        panel.add((Component)this.fillColorLabel, "gapafter 20px");
        label = new JLabel("% opacity");
        panel.add((Component)label, "split 2");
        this.fillOpacitySlider = new JSlider(0, 100, 100);
        this.fillOpacitySlider.setPaintLabels(true);
        this.fillOpacitySlider.setMajorTickSpacing(20);
        this.fillOpacitySlider.addChangeListener(e -> {
            this.opacity = (float)this.fillOpacitySlider.getValue() / 100.0f;
        });
        panel.add((Component)this.fillOpacitySlider, "span, wrap");
        this.controls.put(this.fillOpacitySlider, ControlCategory.FILL);
        label = new JLabel("Point");
        label.setForeground(Color.BLUE);
        panel.add((Component)label, "wrap");
        label = new JLabel("Size");
        panel.add((Component)label, "gapbefore indent, split 2");
        Number[] sizes = new Number[10];
        for (int i = 1; i <= sizes.length; ++i) {
            sizes[i - 1] = i * 5;
        }
        this.pointSizeCBox = new JComboBox<Number>(sizes);
        this.pointSizeCBox.addActionListener(e -> {
            this.pointSize = ((Number)this.pointSizeCBox.getModel().getSelectedItem()).intValue();
        });
        panel.add(this.pointSizeCBox);
        this.controls.put(this.pointSizeCBox, ControlCategory.POINT);
        label = new JLabel("Symbol");
        panel.add((Component)label, "skip, split 2");
        this.pointSymbolCBox = new JComboBox<String>(WELL_KNOWN_SYMBOL_NAMES);
        this.pointSymbolCBox.addActionListener(e -> {
            this.pointSymbolName = WELL_KNOWN_SYMBOL_NAMES[this.pointSymbolCBox.getSelectedIndex()].toString();
        });
        panel.add(this.pointSymbolCBox, "wrap");
        this.controls.put(this.pointSymbolCBox, ControlCategory.POINT);
        label = new JLabel("Labels");
        label.setForeground(Color.BLUE);
        panel.add((Component)label, "wrap");
        JButton fontBtn = new JButton("Font...");
        fontBtn.addActionListener(e -> this.chooseLabelFont());
        this.labelCBox = new JComboBox();
        this.labelCBox.addActionListener(e -> {
            this.labelField = this.labelCBox.getModel().getSelectedItem().toString();
        });
        JCheckBox checkBox = new JCheckBox();
        checkBox.addActionListener(e -> {
            this.labelFeatures = checkBox.isSelected();
            this.labelCBox.setEnabled(this.labelFeatures);
            fontBtn.setEnabled(this.labelFeatures);
        });
        panel.add((Component)checkBox, "gapbefore indent, span, split 3");
        label = new JLabel("Field");
        panel.add(label);
        this.labelCBox.setEnabled(checkBox.isSelected());
        panel.add(this.labelCBox, "wrap");
        fontBtn.setEnabled(checkBox.isSelected());
        panel.add((Component)fontBtn, "wrap");
        btn = new JButton("Apply");
        btn.addActionListener(e -> {
            this.completed = true;
            this.setVisible(false);
        });
        panel.add((Component)btn, "span, split 2, align right");
        btn = new JButton("Cancel");
        btn.addActionListener(e -> {
            this.geomType = null;
            this.setVisible(false);
        });
        panel.add(btn);
        this.getContentPane().add(panel);
        this.pack();
    }

    private void setType() {
        GeometryDescriptor desc = this.schema.getGeometryDescriptor();
        Class clazz = desc.getType().getBinding();
        this.geomType = Geometries.getForBinding((Class)clazz);
        Object labelText = this.schema.getTypeName();
        switch (this.geomType) {
            case POLYGON: 
            case MULTIPOLYGON: {
                labelText = (String)labelText + " (polygon)";
                break;
            }
            case LINESTRING: 
            case MULTILINESTRING: {
                labelText = (String)labelText + " (line)";
                break;
            }
            case POINT: 
            case MULTIPOINT: {
                labelText = (String)labelText + " (point)";
                break;
            }
            default: {
                throw new UnsupportedOperationException("No style method for " + clazz.getName());
            }
        }
        this.typeLabel.setText((String)labelText);
        for (Component c : this.controls.keySet()) {
            switch (this.controls.get(c)) {
                case LINE: {
                    break;
                }
                case FILL: {
                    c.setEnabled(this.geomType != Geometries.LINESTRING && this.geomType != Geometries.MULTILINESTRING);
                    break;
                }
                case POINT: {
                    c.setEnabled(this.geomType == Geometries.POINT || this.geomType == Geometries.MULTIPOINT);
                }
            }
        }
        this.fieldsForLabels = new String[this.schema.getAttributeCount() - 1];
        int k = 0;
        for (AttributeDescriptor attr : this.schema.getAttributeDescriptors()) {
            if (Geometry.class.isAssignableFrom(attr.getType().getBinding())) continue;
            this.fieldsForLabels[k++] = attr.getLocalName();
        }
        this.labelCBox.setModel(new DefaultComboBoxModel<String>(this.fieldsForLabels));
    }

    private void setStyle(Style style) {
        FeatureTypeStyle featureTypeStyle = null;
        Rule rule = null;
        Symbolizer symbolizer = null;
        if (style != null) {
            featureTypeStyle = SLD.featureTypeStyle((Style)style, (SimpleFeatureType)this.schema);
            if (featureTypeStyle != null) {
                if (featureTypeStyle.rules() == null || featureTypeStyle.rules().isEmpty()) {
                    return;
                }
                rule = (Rule)featureTypeStyle.rules().get(0);
                if (rule.symbolizers() == null) {
                    return;
                }
                for (Symbolizer sym : rule.symbolizers()) {
                    if (!this.isValidSymbolizer(sym, this.geomType)) continue;
                    symbolizer = sym;
                    break;
                }
                if (symbolizer == null) {
                    return;
                }
            } else {
                for (int ifts = 0; featureTypeStyle == null && ifts < style.featureTypeStyles().size(); ++ifts) {
                    FeatureTypeStyle fts = (FeatureTypeStyle)style.featureTypeStyles().get(ifts);
                    block2: for (int irule = 0; featureTypeStyle == null && irule < fts.rules().size(); ++irule) {
                        Rule r = (Rule)fts.rules().get(irule);
                        for (Symbolizer sym : r.symbolizers()) {
                            if (!this.isValidSymbolizer(sym, this.geomType)) continue;
                            featureTypeStyle = fts;
                            rule = r;
                            symbolizer = sym;
                            continue block2;
                        }
                    }
                }
            }
            if (featureTypeStyle != null && rule != null && symbolizer != null) {
                this.initControls(featureTypeStyle, rule, symbolizer);
            }
        }
    }

    private void initControls(FeatureTypeStyle fts, Rule rule, Symbolizer sym) {
        switch (this.geomType) {
            case POLYGON: 
            case MULTIPOLYGON: {
                PolygonSymbolizer polySym = (PolygonSymbolizer)sym;
                this.setLineColorItems(SLD.color((Stroke)polySym.getStroke()));
                this.setFillColorItems(SLD.color((Fill)polySym.getFill()));
                this.setFillOpacityItems(SLD.opacity((Fill)polySym.getFill()));
                break;
            }
            case LINESTRING: 
            case MULTILINESTRING: {
                LineSymbolizer lineSym = (LineSymbolizer)sym;
                this.setLineColorItems(SLD.color((LineSymbolizer)lineSym));
                break;
            }
            case POINT: 
            case MULTIPOINT: {
                PointSymbolizer pointSym = (PointSymbolizer)sym;
                this.setLineColorItems(SLD.pointColor((PointSymbolizer)pointSym));
                this.setFillColorItems(SLD.pointFill((PointSymbolizer)pointSym));
                this.setFillOpacityItems(SLD.pointOpacity((PointSymbolizer)pointSym));
                this.setPointSizeItems(SLD.pointSize((PointSymbolizer)pointSym));
                this.setPointSymbolItems(SLD.pointWellKnownName((PointSymbolizer)pointSym));
            }
        }
    }

    private boolean isValidSymbolizer(Symbolizer sym, Geometries type) {
        if (sym != null) {
            if (sym instanceof PolygonSymbolizer) {
                return type == Geometries.POLYGON || type == Geometries.MULTIPOLYGON;
            }
            if (sym instanceof LineSymbolizer) {
                return type == Geometries.LINESTRING || type == Geometries.MULTILINESTRING;
            }
            if (sym instanceof PointSymbolizer) {
                return type == Geometries.POINT || type == Geometries.MULTIPOINT;
            }
        }
        return false;
    }

    private void chooseLineColor() {
        Color color = JColorChooser.showDialog(this, "Choose line color", this.lineColor);
        this.setLineColorItems(color);
    }

    private void setLineColorItems(Color color) {
        if (color != null) {
            this.lineColor = color;
            this.lineColorIcon.setColor(color);
            this.lineColorLabel.repaint();
        }
    }

    private void chooseFillColor() {
        Color color = JColorChooser.showDialog(this, "Choose fill color", this.fillColor);
        this.setFillColorItems(color);
    }

    private void setFillColorItems(Color color) {
        if (color != null) {
            this.fillColor = color;
            this.fillColorIcon.setColor(color);
            this.fillColorLabel.repaint();
        }
    }

    private void setFillOpacityItems(double value) {
        this.opacity = (float)Math.min(1.0, Math.max(0.0, value));
        this.fillOpacitySlider.setValue((int)(this.opacity * 100.0f));
    }

    private void setPointSizeItems(double value) {
        this.pointSize = (float)Math.max(0.0, value);
        int newValue = (int)this.pointSize;
        MutableComboBoxModel model = (MutableComboBoxModel)this.pointSizeCBox.getModel();
        int insert = -1;
        for (int i = 0; i < model.getSize(); ++i) {
            int elValue = ((Number)model.getElementAt(i)).intValue();
            if (elValue == newValue) {
                this.pointSizeCBox.setSelectedIndex(i);
                return;
            }
            if (elValue <= newValue) continue;
            insert = i;
            break;
        }
        if (insert < 0) {
            insert = model.getSize();
            model.addElement(newValue);
        } else {
            model.insertElementAt(newValue, insert);
        }
        this.pointSizeCBox.setSelectedIndex(insert);
    }

    private void setPointSymbolItems(String wellKnownName) {
        if (wellKnownName != null) {
            for (int i = 0; i < WELL_KNOWN_SYMBOL_NAMES.length; ++i) {
                if (!WELL_KNOWN_SYMBOL_NAMES[i].equalsIgnoreCase(wellKnownName)) continue;
                this.pointSymbolName = WELL_KNOWN_SYMBOL_NAMES[i];
                this.pointSymbolCBox.setSelectedIndex(i);
                break;
            }
        }
    }

    private void chooseLabelFont() {
        Font font = JFontChooser.showDialog(this, "Choose label font", this.labelFont);
        if (font != null) {
            this.labelFont = font;
        }
    }

    private static enum ControlCategory {
        LINE,
        FILL,
        POINT;

    }

    private static enum SourceType {
        DATA_STORE,
        MAP_LAYER;

    }
}

