/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.swing.locale;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.swing.locale.PropertiesFileInfo;
import org.geotools.util.URLs;
import org.geotools.util.logging.Logging;

public class PropertiesFileFinder {
    static final Logger LOGGER = Logging.getLogger(PropertiesFileFinder.class);

    public List<PropertiesFileInfo> scan(String resourceDir) throws IOException {
        ArrayList<SingleFileInfo> infoList;
        block18: {
            String path;
            block17: {
                File[] children;
                File mydirectory;
                infoList = new ArrayList<SingleFileInfo>();
                path = this.getSelfPath();
                if (this.isJarPath(path)) {
                    try (JarInputStream jarFile = this.getAsJarInputStream(path);){
                        JarEntry entry;
                        while ((entry = jarFile.getNextJarEntry()) != null) {
                            String name = entry.getName();
                            if (!name.startsWith(resourceDir) || !name.endsWith("properties")) continue;
                            infoList.add(this.parseEntry(resourceDir.length(), name));
                        }
                    }
                }
                if (!this.isBundle(path)) break block17;
                Class<?> classFileLocator = null;
                Method toFileURLMethod = null;
                try {
                    classFileLocator = Class.forName("org.eclipse.core.runtime.FileLocator");
                    toFileURLMethod = classFileLocator.getMethod("toFileURL", URL.class);
                }
                catch (ClassNotFoundException | LinkageError ex) {
                    LOGGER.log(Level.FINE, "", ex);
                    throw new IllegalArgumentException("trying to load a bundle resource " + resourceDir + " whilst the org.eclipse.core.runtime.FileLocator is not available", ex);
                }
                catch (NoSuchMethodException | SecurityException ex) {
                    LOGGER.log(Level.FINE, "", ex);
                    throw new IllegalArgumentException("did not find method toFileUTL in class the org.eclipse.core.runtime.FileLocator", ex);
                }
                URL url = new URL(path);
                try {
                    URL urlFile = (URL)toFileURLMethod.invoke(null, url);
                    if (urlFile == null) {
                        throw new RuntimeException("error while converting the url " + String.valueOf(url) + " to a file");
                    }
                    mydirectory = new File(urlFile.getFile());
                }
                catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                    LOGGER.log(Level.FINE, "", e);
                    throw new RuntimeException("error while converting the url " + String.valueOf(url) + " to a file", e);
                }
                if (mydirectory == null || (children = mydirectory.listFiles()) == null) break block18;
                for (File child : children) {
                    String name;
                    if (child == null || !(name = child.getName()).endsWith(".properties")) continue;
                    infoList.add(this.parseEntry(0, name));
                }
                break block18;
            }
            File localDir = this.getAsLocalDir(path);
            File[] children = localDir.listFiles();
            if (children != null) {
                for (File child : children) {
                    String name;
                    if (child == null || !child.isFile() || !(name = child.getName()).endsWith(".properties")) continue;
                    infoList.add(this.parseEntry(0, name));
                }
            }
        }
        return this.createReturnList(infoList);
    }

    private String getSelfPath() {
        String className = this.getClass().getSimpleName() + ".class";
        URL url = this.getClass().getResource(className);
        if (url.getProtocol().equals("file")) {
            return URLs.urlToFile((URL)url).getPath();
        }
        return url.toString();
    }

    private boolean isJarPath(String path) {
        return path.contains(".jar!");
    }

    private boolean isBundle(String path) {
        return path.toLowerCase().startsWith("bundleresource:/");
    }

    private JarInputStream getAsJarInputStream(String jarPath) throws IOException {
        URL jarUrl = new URL(jarPath);
        return new JarInputStream(jarUrl.openStream());
    }

    private File getAsLocalDir(String dirPath) {
        int pos = dirPath.lastIndexOf(File.separatorChar);
        File file = new File(dirPath.substring(0, pos));
        if (!file.exists() || !file.isDirectory()) {
            throw new IllegalArgumentException("Invalid directory path: " + String.valueOf(file));
        }
        return file;
    }

    private SingleFileInfo parseEntry(int prefixLength, String entry) {
        entry = entry.substring(prefixLength, entry.indexOf(".properties"));
        String[] parts = entry.split("_");
        String baseName = parts[0];
        String language = "";
        String country = "";
        String variant = "";
        if (parts.length > 1) {
            language = parts[1];
        }
        if (parts.length > 2) {
            country = parts[2];
        }
        if (parts.length > 3) {
            variant = parts[3];
        }
        Locale locale = parts.length == 1 ? Locale.ROOT : new Locale(language, country, variant);
        return new SingleFileInfo(baseName, locale);
    }

    private List<PropertiesFileInfo> createReturnList(List<SingleFileInfo> infoList) {
        ArrayList<PropertiesFileInfo> pfiList = new ArrayList<PropertiesFileInfo>();
        if (!infoList.isEmpty()) {
            Collections.sort(infoList, (o1, o2) -> o1.name.compareTo(o2.name));
            String curName = infoList.get((int)0).name;
            ArrayList<Locale> locales = new ArrayList<Locale>();
            ListIterator<SingleFileInfo> iter = infoList.listIterator();
            while (iter.hasNext()) {
                SingleFileInfo sfi = iter.next();
                if (sfi.name.equals(curName)) {
                    locales.add(sfi.locale);
                    continue;
                }
                pfiList.add(new PropertiesFileInfo(curName, locales));
                curName = sfi.name;
                locales.clear();
                locales.add(sfi.locale);
            }
            pfiList.add(new PropertiesFileInfo(curName, locales));
        }
        return pfiList;
    }

    private static class SingleFileInfo {
        String name;
        Locale locale;

        public SingleFileInfo(String name, Locale locale) {
            this.name = name;
            this.locale = locale;
        }
    }
}

