/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.swing.event;

import java.awt.Rectangle;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComponent;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.swing.MapPane;
import org.geotools.swing.event.KeyInfo;
import org.opengis.geometry.Envelope;

public class MapPaneKeyHandler
extends KeyAdapter {
    private static final double SCROLL_FRACTION = 0.05;
    private static final double ZOOM_FRACTION = 1.5;
    private static final Map<KeyInfo, Action> defaultBindings = new HashMap<KeyInfo, Action>();
    private final Map<KeyInfo, Action> bindings = new HashMap<KeyInfo, Action>(defaultBindings);
    private final MapPane mapPane;

    public MapPaneKeyHandler(MapPane mapPane) {
        this.mapPane = mapPane;
    }

    public void setDefaultBindings() {
        this.bindings.clear();
        this.bindings.putAll(defaultBindings);
    }

    public Map<KeyInfo, Action> getBindings() {
        HashMap<KeyInfo, Action> map = new HashMap<KeyInfo, Action>();
        for (Map.Entry<KeyInfo, Action> e : this.bindings.entrySet()) {
            map.put(new KeyInfo(e.getKey()), e.getValue());
        }
        return map;
    }

    public KeyInfo getBindingForAction(Action action) {
        if (action == null) {
            throw new IllegalArgumentException("action must not be null");
        }
        KeyInfo keyInfo = null;
        for (Map.Entry<KeyInfo, Action> e : this.bindings.entrySet()) {
            if (e.getValue() != action) continue;
            keyInfo = new KeyInfo(e.getKey());
            break;
        }
        return keyInfo;
    }

    public void setBinding(KeyInfo keyInfo, Action action) {
        if (keyInfo == null) {
            throw new IllegalArgumentException("keyInfo must not be null");
        }
        if (action == null) {
            throw new IllegalArgumentException("action must not be null");
        }
        this.bindings.put(new KeyInfo(keyInfo), action);
    }

    public void setBindings(Map<KeyInfo, Action> newBindings) {
        if (newBindings == null) {
            throw new IllegalArgumentException("argument must not be null");
        }
        for (Map.Entry<KeyInfo, Action> e : newBindings.entrySet()) {
            this.setBinding(e.getKey(), e.getValue());
        }
    }

    public void setAllBindings(Map<KeyInfo, Action> newBindings) {
        if (newBindings == null) {
            throw new IllegalArgumentException("argument must not be null");
        }
        this.bindings.clear();
        this.setBindings(newBindings);
    }

    @Override
    public void keyPressed(KeyEvent e) {
        for (KeyInfo keyInfo : this.bindings.keySet()) {
            if (!keyInfo.matchesEvent(e)) continue;
            this.processAction(this.bindings.get(keyInfo));
        }
    }

    private void processAction(Action action) {
        switch (action) {
            case SCROLL_LEFT: 
            case SCROLL_RIGHT: 
            case SCROLL_UP: 
            case SCROLL_DOWN: {
                this.scroll(action);
                break;
            }
            case ZOOM_IN: 
            case ZOOM_OUT: 
            case ZOOM_FULL_EXTENT: {
                this.zoom(action);
            }
        }
    }

    private void scroll(Action action) {
        Rectangle r = ((JComponent)((Object)this.mapPane)).getVisibleRect();
        if (r != null && !r.isEmpty()) {
            int dx = 0;
            int dy = 0;
            switch (action) {
                case SCROLL_LEFT: {
                    dx = Math.max(1, (int)(r.getWidth() * 0.05));
                    break;
                }
                case SCROLL_RIGHT: {
                    dx = Math.min(-1, (int)(-r.getWidth() * 0.05));
                    break;
                }
                case SCROLL_UP: {
                    dy = Math.max(1, (int)(r.getWidth() * 0.05));
                    break;
                }
                case SCROLL_DOWN: {
                    dy = Math.min(-1, (int)(-r.getWidth() * 0.05));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid action argument: " + String.valueOf((Object)action));
                }
            }
            this.mapPane.moveImage(dx, dy);
        }
    }

    private void zoom(Action action) {
        ReferencedEnvelope env = this.mapPane.getDisplayArea();
        if (!env.isEmpty()) {
            double zoom;
            switch (action) {
                case ZOOM_FULL_EXTENT: {
                    this.mapPane.reset();
                    return;
                }
                case ZOOM_IN: {
                    zoom = 0.6666666666666666;
                    break;
                }
                case ZOOM_OUT: {
                    zoom = 1.5;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("invalid action argument: " + String.valueOf((Object)action));
                }
            }
            double centreX = env.getMedian(0);
            double centreY = env.getMedian(1);
            double w = env.getWidth() * zoom;
            double h = env.getHeight() * zoom;
            ReferencedEnvelope newEnv = new ReferencedEnvelope(centreX - w / 2.0, centreX + w / 2.0, centreY - h / 2.0, centreY + h / 2.0, env.getCoordinateReferenceSystem());
            this.mapPane.setDisplayArea((Envelope)newEnv);
        }
    }

    static {
        defaultBindings.put(new KeyInfo(37, 0, "Left"), Action.SCROLL_LEFT);
        defaultBindings.put(new KeyInfo(39, 0, "Right"), Action.SCROLL_RIGHT);
        defaultBindings.put(new KeyInfo(38, 0, "Up"), Action.SCROLL_UP);
        defaultBindings.put(new KeyInfo(40, 0, "Down"), Action.SCROLL_DOWN);
        defaultBindings.put(new KeyInfo(38, 64, "Shift+Up"), Action.ZOOM_IN);
        defaultBindings.put(new KeyInfo(40, 64, "Shift+Down"), Action.ZOOM_OUT);
        defaultBindings.put(new KeyInfo(61, 0, "="), Action.ZOOM_FULL_EXTENT);
    }

    public static enum Action {
        SCROLL_LEFT,
        SCROLL_RIGHT,
        SCROLL_UP,
        SCROLL_DOWN,
        ZOOM_IN,
        ZOOM_OUT,
        ZOOM_FULL_EXTENT;

    }
}

