/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.swing.event;

import java.awt.event.KeyEvent;

public class KeyInfo {
    private final int keyCode;
    private final int modifiers;
    private final String desc;

    public KeyInfo(int keyCode, int modifiers, String desc) {
        this.keyCode = keyCode;
        this.modifiers = modifiers;
        this.desc = desc == null || desc.trim().length() == 0 ? String.format("KeyInfo(%d, %d)", keyCode, modifiers) : desc;
    }

    public KeyInfo(KeyInfo keyInfo) {
        if (keyInfo == null) {
            throw new IllegalArgumentException("keyInfo must not be null");
        }
        this.keyCode = keyInfo.keyCode;
        this.modifiers = keyInfo.modifiers;
        this.desc = keyInfo.desc;
    }

    public int getKeyCode() {
        return this.keyCode;
    }

    public int getModifiers() {
        return this.modifiers;
    }

    public String toString() {
        return this.desc;
    }

    public boolean matchesEvent(KeyEvent e) {
        return e != null && e.getKeyCode() == this.keyCode && (e.getModifiersEx() ^ this.modifiers) == 0;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        KeyInfo other = (KeyInfo)obj;
        if (this.keyCode != other.keyCode) {
            return false;
        }
        return this.modifiers == other.modifiers;
    }

    public int hashCode() {
        int hash = 5;
        hash = 59 * hash + this.keyCode;
        hash = 59 * hash + this.modifiers;
        return hash;
    }
}

