/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.swing;

import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import org.geotools.map.Layer;

public class MapLayerTableCellRenderer
extends JPanel
implements ListCellRenderer<Layer> {
    private static final long serialVersionUID = 7907189175227502588L;
    private static final int CELL_PADDING = 5;
    private static final int CELL_HEIGHT;
    private static final Rectangle SELECT_LABEL_BOUNDS;
    private static final Rectangle VISIBLE_LABEL_BOUNDS;
    private static final Rectangle STYLE_LABEL_BOUNDS;
    private static final Rectangle REMOVE_LABEL_BOUNDS;
    private static final Rectangle NAME_LABEL_BOUNDS;
    private JLabel visibleLabel = new JLabel();
    private JLabel selectedLabel;
    private JLabel styleLabel;
    private JLabel removeLayerLabel;
    private JLabel nameLabel;

    public static int getCellHeight() {
        return CELL_HEIGHT;
    }

    public static boolean hitVisibilityLabel(Point p) {
        return VISIBLE_LABEL_BOUNDS.contains(p);
    }

    public static boolean hitSelectionLabel(Point p) {
        return SELECT_LABEL_BOUNDS.contains(p);
    }

    public static boolean hitStyleLabel(Point p) {
        return STYLE_LABEL_BOUNDS.contains(p);
    }

    public static boolean hitRemoveLabel(Point p) {
        return REMOVE_LABEL_BOUNDS.contains(p);
    }

    public static boolean hitNameLabel(Point p) {
        return NAME_LABEL_BOUNDS.contains(p);
    }

    public MapLayerTableCellRenderer() {
        super(new FlowLayout(0, 5, 5));
        this.add(this.visibleLabel);
        this.selectedLabel = new JLabel();
        this.add(this.selectedLabel);
        this.styleLabel = new JLabel(LayerControlItem.STYLE.getIcon());
        this.add(this.styleLabel);
        this.removeLayerLabel = new JLabel(LayerControlItem.REMOVE.getIcon());
        this.add(this.removeLayerLabel);
        this.nameLabel = new JLabel();
        this.add(this.nameLabel);
    }

    @Override
    public Component getListCellRendererComponent(JList list, Layer value, int index, boolean isSelected, boolean cellHasFocus) {
        Layer layer = value;
        String name = layer.getTitle();
        if (name == null || name.trim().length() == 0) {
            name = layer.getFeatureSource().getName().getLocalPart();
        }
        this.nameLabel.setText(name);
        this.visibleLabel.setIcon(layer.isVisible() ? LayerControlItem.VISIBLE.getIcon() : LayerControlItem.VISIBLE.getOffIcon());
        this.selectedLabel.setIcon(layer.isSelected() ? LayerControlItem.SELECTED.getIcon() : LayerControlItem.SELECTED.getOffIcon());
        if (isSelected) {
            this.setBackground(list.getSelectionBackground());
            this.setForeground(list.getSelectionForeground());
        } else {
            this.setBackground(list.getBackground());
            this.setForeground(list.getForeground());
        }
        this.setEnabled(list.isEnabled());
        this.setFont(list.getFont());
        this.setOpaque(true);
        return this;
    }

    static {
        int maxIconHeight = 0;
        for (LayerControlItem state : LayerControlItem.values()) {
            maxIconHeight = Math.max(maxIconHeight, state.getIcon().getIconHeight());
        }
        CELL_HEIGHT = maxIconHeight + 10;
        int x = 5;
        int h = LayerControlItem.VISIBLE.getIcon().getIconHeight();
        int w = LayerControlItem.VISIBLE.getIcon().getIconWidth();
        VISIBLE_LABEL_BOUNDS = new Rectangle(x, 5, w, h);
        x += w + 5;
        h = LayerControlItem.SELECTED.getIcon().getIconHeight();
        w = LayerControlItem.SELECTED.getIcon().getIconWidth();
        SELECT_LABEL_BOUNDS = new Rectangle(x, 5, w, h);
        x += w + 5;
        h = LayerControlItem.STYLE.getIcon().getIconHeight();
        w = LayerControlItem.STYLE.getIcon().getIconWidth();
        STYLE_LABEL_BOUNDS = new Rectangle(x, 5, w, h);
        x += w + 5;
        h = LayerControlItem.REMOVE.getIcon().getIconHeight();
        w = LayerControlItem.REMOVE.getIcon().getIconWidth();
        REMOVE_LABEL_BOUNDS = new Rectangle(x, 5, w, h);
        NAME_LABEL_BOUNDS = new Rectangle(x += w + 5, 5, 1000, CELL_HEIGHT - 10);
    }

    public static enum LayerControlItem {
        VISIBLE(new ImageIcon(MapLayerTableCellRenderer.class.getResource("/org/geotools/swing/icons/eye_open.png")), new ImageIcon(MapLayerTableCellRenderer.class.getResource("/org/geotools/swing/icons/eye_closed.png"))),
        SELECTED(new ImageIcon(MapLayerTableCellRenderer.class.getResource("/org/geotools/swing/icons/tick.png")), new ImageIcon(MapLayerTableCellRenderer.class.getResource("/org/geotools/swing/icons/cross.png"))),
        STYLE(new ImageIcon(MapLayerTableCellRenderer.class.getResource("/org/geotools/swing/icons/style_layer.png")), null),
        REMOVE(new ImageIcon(MapLayerTableCellRenderer.class.getResource("/org/geotools/swing/icons/remove_layer.png")), null);

        private ImageIcon onIcon;
        private ImageIcon offIcon;

        private LayerControlItem(ImageIcon onIcon, ImageIcon offIcon) {
            this.onIcon = onIcon;
            this.offIcon = offIcon;
        }

        public Icon getIcon() {
            return this.onIcon;
        }

        public Icon getOffIcon() {
            if (this.offIcon != null) {
                return this.offIcon;
            }
            return this.onIcon;
        }
    }
}

