/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.lang.ref.WeakReference;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import org.geotools.map.Layer;
import org.geotools.map.MapContent;
import org.geotools.map.MapLayerListEvent;
import org.geotools.map.MapLayerListListener;
import org.geotools.map.StyleLayer;
import org.geotools.styling.Style;
import org.geotools.swing.MapLayerTableCellRenderer;
import org.geotools.swing.MapPane;
import org.geotools.swing.control.DnDList;
import org.geotools.swing.control.DnDListModel;
import org.geotools.swing.event.MapPaneAdapter;
import org.geotools.swing.event.MapPaneEvent;
import org.geotools.swing.locale.LocaleUtils;
import org.geotools.swing.styling.JSimpleStyleDialog;

public class MapLayerTable
extends JPanel {
    private static final String CLASS_NAME = "MapLayerTable";
    private static final String LIST_TITLE = LocaleUtils.getValue("MapLayerTable", "ListTitle");
    private static final String SHOW_HIDE_LAYER = LocaleUtils.getValue("MapLayerTable", "ShowHideLayer");
    private static final String SHOW_ALL_LAYERS = LocaleUtils.getValue("MapLayerTable", "ShowAllLayers");
    private static final String HIDE_ALL_LAYERS = LocaleUtils.getValue("MapLayerTable", "HideAllLayers");
    private static final String SELECT_LAYER = LocaleUtils.getValue("MapLayerTable", "SelectLayer");
    private static final String SELECT_ALL_LAYERS = LocaleUtils.getValue("MapLayerTable", "SelectAllLayers");
    private static final String DESELECT_ALL_LAYERS = LocaleUtils.getValue("MapLayerTable", "DeselectAllLayers");
    private static final String RENAME_LAYER = LocaleUtils.getValue("MapLayerTable", "RenameLayer");
    private static final String RENAME_LAYER_MESSAGE = LocaleUtils.getValue("MapLayerTable", "RenameLayer_Message");
    private static final String REMOVE_LAYER = LocaleUtils.getValue("MapLayerTable", "RemoveLayer");
    private static final String REMOVE_LAYER_MESSAGE = LocaleUtils.getValue("MapLayerTable", "RemoveLayer_ConfirmMessage");
    private static final String REMOVE_LAYER_TITLE = LocaleUtils.getValue("MapLayerTable", "RemoveLayer_ConfirmTitle");
    private static final String STYLE_LAYER = LocaleUtils.getValue("MapLayerTable", "StyleLayer");
    private MapPane mapPane;
    private DnDListModel<Layer> listModel;
    private DnDList<Layer> list;
    private JScrollPane scrollPane;
    private static final long DOUBLE_CLICK_TIME = 500L;
    private long lastClickTime = 0L;
    private boolean confirmRemove = true;
    private Listener listener = new Listener(this);

    public MapLayerTable() {
        this((MapPane)null);
    }

    public MapLayerTable(MapPane mapPane) {
        this.initComponents();
        this.doSetMapPane(mapPane);
    }

    public void setMapPane(MapPane mapPane) {
        this.doSetMapPane(mapPane);
    }

    private void doSetMapPane(MapPane newMapPane) {
        this.listener.disconnectFromMapPane();
        this.mapPane = newMapPane;
        this.listener.connectToMapPane(newMapPane);
    }

    public void onAddLayer(Layer layer) {
        this.listModel.insertItem(0, layer);
    }

    void onRemoveLayer(Layer layer) {
        this.listModel.removeItem(layer);
    }

    public void repaint(Layer layer) {
        int index = this.listModel.indexOf(layer);
        this.list.repaint(this.list.getCellBounds(index, index));
    }

    public void clear() {
        this.listModel.clear();
    }

    private void initComponents() {
        this.listModel = new DnDListModel();
        this.list = new DnDList<Layer>(this.listModel){
            private static final long serialVersionUID = 1289744440656016412L;

            @Override
            public String getToolTipText(MouseEvent e) {
                Rectangle r;
                int item = MapLayerTable.this.list.locationToIndex(e.getPoint());
                if (item >= 0 && (r = MapLayerTable.this.list.getCellBounds(item, item)).contains(e.getPoint())) {
                    Point p = new Point(e.getPoint().x, e.getPoint().y - r.y);
                    if (MapLayerTableCellRenderer.hitSelectionLabel(p)) {
                        return SELECT_LAYER;
                    }
                    if (MapLayerTableCellRenderer.hitVisibilityLabel(p)) {
                        return SHOW_HIDE_LAYER;
                    }
                    if (MapLayerTableCellRenderer.hitStyleLabel(p)) {
                        return STYLE_LAYER;
                    }
                    if (MapLayerTableCellRenderer.hitRemoveLabel(p)) {
                        return REMOVE_LAYER;
                    }
                    if (MapLayerTableCellRenderer.hitNameLabel(p)) {
                        return RENAME_LAYER;
                    }
                }
                return null;
            }
        };
        this.listModel.addListDataListener(new ListDataListener(){

            @Override
            public void intervalAdded(ListDataEvent e) {
            }

            @Override
            public void intervalRemoved(ListDataEvent e) {
            }

            @Override
            public void contentsChanged(ListDataEvent e) {
                MapLayerTable.this.onReorderLayers(e);
            }
        });
        this.list.setCellRenderer(new MapLayerTableCellRenderer());
        this.list.setFixedCellHeight(MapLayerTableCellRenderer.getCellHeight());
        this.list.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                long clickTime = System.currentTimeMillis();
                boolean doubleClick = clickTime - MapLayerTable.this.lastClickTime < 500L;
                MapLayerTable.this.lastClickTime = clickTime;
                MapLayerTable.this.onLayerItemClicked(e, doubleClick);
            }
        });
        this.scrollPane = new JScrollPane(this.list, 20, 32);
        this.scrollPane.setBorder(BorderFactory.createTitledBorder(LIST_TITLE));
        JPanel btnPanel = new JPanel();
        Icon showIcon = MapLayerTableCellRenderer.LayerControlItem.VISIBLE.getIcon();
        JButton btn = new JButton(showIcon);
        btn.setToolTipText(SHOW_ALL_LAYERS);
        btn.addActionListener(e -> this.onShowAllLayers());
        btnPanel.add(btn);
        Icon hideIcon = MapLayerTableCellRenderer.LayerControlItem.VISIBLE.getOffIcon();
        btn = new JButton(hideIcon);
        btn.setToolTipText(HIDE_ALL_LAYERS);
        btn.addActionListener(e -> this.onHideAllLayers());
        btnPanel.add(btn);
        Icon onIcon = MapLayerTableCellRenderer.LayerControlItem.SELECTED.getIcon();
        btn = new JButton(onIcon);
        btn.setToolTipText(SELECT_ALL_LAYERS);
        btn.addActionListener(e -> this.onSelectAllLayers());
        btnPanel.add(btn);
        Icon offIcon = MapLayerTableCellRenderer.LayerControlItem.SELECTED.getOffIcon();
        btn = new JButton(offIcon);
        btn.setToolTipText(DESELECT_ALL_LAYERS);
        btn.addActionListener(e -> this.onUnselectAllLayers());
        btnPanel.add(btn);
        this.setLayout(new BorderLayout());
        this.add((Component)this.scrollPane, "Center");
        this.add((Component)btnPanel, "South");
    }

    private void onLayerItemClicked(MouseEvent ev, boolean doubleClick) {
        Rectangle r;
        int item = this.list.locationToIndex(ev.getPoint());
        if (item >= 0 && (r = this.list.getCellBounds(item, item)).contains(ev.getPoint())) {
            Layer layer = this.listModel.getElementAt(item);
            Point p = new Point(ev.getPoint().x, ev.getPoint().y - r.y);
            if (MapLayerTableCellRenderer.hitSelectionLabel(p)) {
                layer.setSelected(!layer.isSelected());
            } else if (MapLayerTableCellRenderer.hitVisibilityLabel(p)) {
                layer.setVisible(!layer.isVisible());
            } else if (MapLayerTableCellRenderer.hitStyleLabel(p)) {
                this.doSetStyle(layer);
            } else if (MapLayerTableCellRenderer.hitRemoveLabel(p)) {
                this.doRemoveLayer(layer);
            } else if (MapLayerTableCellRenderer.hitNameLabel(p) && doubleClick) {
                this.doSetLayerName(layer);
            }
        }
    }

    private void doSetStyle(Layer layer) {
        StyleLayer styleLayer;
        Style style;
        if (layer instanceof StyleLayer && (style = JSimpleStyleDialog.showDialog((Component)this, styleLayer = (StyleLayer)layer)) != null) {
            styleLayer.setStyle(style);
        }
    }

    private void doSetLayerName(Layer layer) {
        String name = JOptionPane.showInputDialog(RENAME_LAYER_MESSAGE);
        if (name != null && name.trim().length() > 0) {
            layer.setTitle(name.trim());
        }
    }

    private void doRemoveLayer(Layer layer) {
        int confirm;
        if (this.confirmRemove && (confirm = JOptionPane.showConfirmDialog(null, REMOVE_LAYER_MESSAGE, REMOVE_LAYER_TITLE, 0)) != 0) {
            return;
        }
        this.mapPane.getMapContent().removeLayer(layer);
    }

    private void onReorderLayers(ListDataEvent ev) {
        ((JComponent)((Object)this.mapPane)).setIgnoreRepaint(true);
        for (int pos = ev.getIndex0(); pos <= ev.getIndex1(); ++pos) {
            Layer layer = this.listModel.getElementAt(pos);
            int newContextPos = this.listModel.getSize() - pos - 1;
            int curContextPos = this.mapPane.getMapContent().layers().indexOf(layer);
            if (curContextPos == newContextPos) continue;
            this.mapPane.getMapContent().moveLayer(curContextPos, newContextPos);
        }
        ((JComponent)((Object)this.mapPane)).setIgnoreRepaint(false);
        ((JComponent)((Object)this.mapPane)).repaint();
    }

    private void onShowAllLayers() {
        if (this.mapPane != null && this.mapPane.getMapContent() != null) {
            for (Layer layer : this.mapPane.getMapContent().layers()) {
                if (layer.isVisible()) continue;
                layer.setVisible(true);
            }
        }
    }

    private void onHideAllLayers() {
        if (this.mapPane != null && this.mapPane.getMapContent() != null) {
            for (Layer layer : this.mapPane.getMapContent().layers()) {
                if (!layer.isVisible()) continue;
                layer.setVisible(false);
            }
        }
    }

    private void onSelectAllLayers() {
        if (this.mapPane != null && this.mapPane.getMapContent() != null) {
            for (Layer layer : this.mapPane.getMapContent().layers()) {
                if (layer.isSelected()) continue;
                layer.setSelected(true);
            }
        }
    }

    private void onUnselectAllLayers() {
        if (this.mapPane != null && this.mapPane.getMapContent() != null) {
            for (Layer layer : this.mapPane.getMapContent().layers()) {
                if (!layer.isSelected()) continue;
                layer.setSelected(false);
            }
        }
    }

    private static final class Listener
    extends MapPaneAdapter
    implements MapLayerListListener {
        private final MapLayerTable table;
        private WeakReference<MapPane> paneRef;
        private WeakReference<MapContent> contentRef;

        Listener(MapLayerTable table) {
            this.table = table;
        }

        void connectToMapPane(MapPane newMapPane) {
            if (newMapPane != null) {
                this.paneRef = new WeakReference<MapPane>(newMapPane);
                newMapPane.addMapPaneListener(this);
                this.disconnectFromMapContent();
                this.connectToMapContent(newMapPane.getMapContent());
            }
        }

        void disconnectFromMapPane() {
            if (this.paneRef != null) {
                MapPane prevMapPane = (MapPane)this.paneRef.get();
                this.paneRef = null;
                if (prevMapPane != null) {
                    prevMapPane.removeMapPaneListener(this);
                }
            }
        }

        void connectToMapContent(MapContent newMapContent) {
            if (newMapContent != null) {
                this.contentRef = new WeakReference<MapContent>(newMapContent);
                newMapContent.addMapLayerListListener((MapLayerListListener)this);
                for (Layer layer : newMapContent.layers()) {
                    this.table.onAddLayer(layer);
                }
            }
        }

        private void disconnectFromMapContent() {
            if (this.contentRef != null) {
                MapContent prevMapContent = (MapContent)this.contentRef.get();
                this.contentRef = null;
                if (prevMapContent != null) {
                    prevMapContent.removeMapLayerListListener((MapLayerListListener)this);
                }
                this.table.clear();
            }
        }

        @Override
        public void onNewMapContent(MapPaneEvent ev) {
            this.table.clear();
            this.disconnectFromMapContent();
            MapContent newMapContent = (MapContent)ev.getData();
            this.connectToMapContent(newMapContent);
            if (newMapContent != null) {
                for (Layer layer : newMapContent.layers()) {
                    this.table.onAddLayer(layer);
                }
            }
        }

        public void layerAdded(MapLayerListEvent event) {
            if (event.getLayer() == null) {
                List layers = this.table.mapPane.getMapContent().layers();
                for (Layer l : layers.subList(event.getFromIndex(), event.getToIndex() + 1)) {
                    this.table.onAddLayer(l);
                }
            } else {
                this.table.onAddLayer(event.getLayer());
            }
        }

        public void layerRemoved(MapLayerListEvent event) {
            this.table.onRemoveLayer(event.getLayer());
        }

        public void layerChanged(MapLayerListEvent event) {
            this.table.repaint(event.getLayer());
        }

        public void layerMoved(MapLayerListEvent event) {
        }

        public void layerPreDispose(MapLayerListEvent event) {
        }
    }
}

