/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.swing.wizard;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowEvent;
import java.util.HashMap;
import java.util.logging.Logger;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.geotools.gml.SubHandlerLinearRing;
import org.geotools.swing.wizard.JPage;
import org.geotools.util.logging.Logging;

public class JWizard
extends JDialog {
    static final Logger LOGGER = Logging.getLogger(SubHandlerLinearRing.class);
    private static final long serialVersionUID = 1L;
    public static final int FINISH = 0;
    public static final int CANCEL = 1;
    public static final int ERROR = 2;
    Controller controller = new Controller();
    HashMap<String, JPage> model = new HashMap();
    JPage current;
    private JPanel cardPanel;
    private CardLayout cardLayout;
    private JButton backButton;
    private JButton nextButton;
    private JButton finishButton;
    private JButton cancelButton;
    private int returnCode;

    public JWizard(String title) throws HeadlessException {
        this.setTitle(title);
        this.initComponents();
    }

    public JWizard(Dialog owner, String title) throws HeadlessException {
        super(owner, title, true, null);
        this.initComponents();
    }

    private void initComponents() {
        JPanel buttonPanel = new JPanel();
        Box buttonBox = new Box(0);
        this.cardPanel = new JPanel();
        this.cardPanel.setBorder(new EmptyBorder(new Insets(5, 10, 5, 10)));
        this.cardLayout = new CardLayout();
        this.cardPanel.setLayout(this.cardLayout);
        this.backButton = new JButton("Back");
        this.nextButton = new JButton("Next");
        this.finishButton = new JButton("Finish");
        this.cancelButton = new JButton("Cancel");
        this.backButton.addActionListener(this.controller);
        this.nextButton.addActionListener(this.controller);
        this.finishButton.addActionListener(this.controller);
        this.cancelButton.addActionListener(this.controller);
        buttonPanel.setLayout(new BorderLayout());
        buttonPanel.add((Component)new JSeparator(), "North");
        buttonBox.setBorder(new EmptyBorder(new Insets(5, 10, 5, 10)));
        buttonBox.add(this.backButton);
        buttonBox.add(Box.createHorizontalStrut(10));
        buttonBox.add(this.nextButton);
        buttonBox.add(Box.createHorizontalStrut(30));
        buttonBox.add(this.finishButton);
        buttonBox.add(Box.createHorizontalStrut(10));
        buttonBox.add(this.cancelButton);
        buttonPanel.add((Component)buttonBox, "East");
        this.getContentPane().add((Component)buttonPanel, "South");
        this.getContentPane().add((Component)new JScrollPane(this.cardPanel), "Center");
    }

    public Boolean isCancelEnabled() {
        return this.cancelButton == null ? null : Boolean.valueOf(this.cancelButton.isEnabled());
    }

    public void setCancelEnabled(Boolean isEnabled) {
        Boolean oldValue = this.cancelButton.isEnabled();
        if (!isEnabled.equals(oldValue)) {
            this.firePropertyChange("isCancelEnabled", oldValue, isEnabled);
            this.cancelButton.setEnabled(isEnabled);
        }
    }

    public Boolean isNextEnabled() {
        return this.nextButton == null ? null : Boolean.valueOf(this.nextButton.isEnabled());
    }

    public void setNextEnabled(Boolean isEnabled) {
        Boolean oldValue = this.nextButton.isEnabled();
        if (!isEnabled.equals(oldValue)) {
            this.firePropertyChange("isNextEnabled", oldValue, isEnabled);
            this.nextButton.setEnabled(isEnabled);
        }
    }

    public void setFinishEnabled(Boolean isEnabled) {
        Boolean oldValue = this.finishButton.isEnabled();
        if (!isEnabled.equals(oldValue)) {
            this.firePropertyChange("isFinishEnabled", oldValue, isEnabled);
            this.finishButton.setEnabled(isEnabled);
        }
    }

    public Boolean isBackEnabled() {
        return this.backButton == null ? null : Boolean.valueOf(this.backButton.isEnabled());
    }

    public void setBackEnabled(Boolean isEnabled) {
        Boolean oldValue = this.backButton.isEnabled();
        if (!isEnabled.equals(oldValue)) {
            this.firePropertyChange("isBackEnabled", oldValue, isEnabled);
            this.backButton.setEnabled(isEnabled);
        }
    }

    protected void close(int code) {
        this.returnCode = code;
        for (Component card : this.cardPanel.getComponents()) {
            String id = card.getName();
            JPage page = this.model.get(id);
            if (page == null) continue;
            try {
                page.dispose();
            }
            catch (Throwable t) {
                LOGGER.info(id + " close: " + String.valueOf(t));
            }
        }
        this.dispose();
    }

    public void windowClosing(WindowEvent e) {
        this.returnCode = 1;
    }

    public int getReturnCode() {
        return this.returnCode;
    }

    public int showModalDialog() {
        this.setModal(true);
        this.pack();
        this.setVisible(true);
        return this.returnCode;
    }

    public void setCurrentPanel(String id) {
        JPage page;
        JPage old;
        if (id == null) {
            this.close(2);
        }
        if ((old = this.current) != null) {
            old.preClosePanel();
        }
        if (!this.model.containsKey(id)) {
            this.close(2);
        }
        if ((page = this.model.get(id)) == null) {
            this.close(2);
            return;
        }
        this.current = page;
        JPanel panel = null;
        for (Component card : this.cardPanel.getComponents()) {
            if (!id.equals(card.getName())) continue;
            panel = (JPanel)card;
            break;
        }
        if (panel == null) {
            panel = page.getPanel();
            if (panel == null) {
                this.close(2);
                return;
            }
            panel.setName(id);
            this.cardPanel.add((Component)panel, id);
        }
        this.controller.syncButtonsToPage();
        page.preDisplayPanel();
        this.cardLayout.show(this.cardPanel, id);
        page.postDisplayPanel();
    }

    public void registerWizardPanel(JPage page) {
        page.setJWizard(this);
        this.model.put(page.getPageIdentifier(), page);
        page.setJWizard(this);
        if (page.getPageIdentifier() == "Default") {
            this.setCurrentPanel(page.getPageIdentifier());
        }
    }

    public Controller getController() {
        return this.controller;
    }

    public class Controller
    implements ActionListener,
    KeyListener,
    DocumentListener,
    ListSelectionListener {
        public boolean listen = true;

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!this.listen) {
                return;
            }
            if (e.getSource() == JWizard.this.cancelButton || e.getActionCommand().equals("Canel")) {
                this.cancelButtonPressed();
            } else if (e.getSource() == JWizard.this.backButton || e.getActionCommand().equals("Back")) {
                this.backButtonPressed();
            } else if (e.getSource() == JWizard.this.nextButton || e.getActionCommand().equals("Next")) {
                this.nextButtonPressed();
            } else if (e.getSource() == JWizard.this.finishButton || e.getActionCommand().equals("Finish")) {
                this.finishButtonPressed();
            } else {
                this.syncButtonsToPage();
            }
        }

        private void cancelButtonPressed() {
            JWizard.this.close(1);
        }

        private void finishButtonPressed() {
            if (JWizard.this.current == null) {
                JWizard.this.close(2);
                return;
            }
            if (!JWizard.this.current.isValid()) {
                this.syncButtonsToPage();
                return;
            }
            JWizard.this.current.preClosePanel();
            JWizard.this.close(0);
        }

        private void nextButtonPressed() {
            if (JWizard.this.current == null) {
                JWizard.this.close(2);
                return;
            }
            if (!JWizard.this.current.isValid()) {
                this.syncButtonsToPage();
                return;
            }
            String nextId = JWizard.this.current.getNextPageIdentifier();
            JWizard.this.setCurrentPanel(nextId);
        }

        private void backButtonPressed() {
            if (JWizard.this.current == null) {
                JWizard.this.close(2);
                return;
            }
            String backId = JWizard.this.current.getBackPageIdentifier();
            JWizard.this.setCurrentPanel(backId);
        }

        public void setListen(boolean listen) {
            this.listen = listen;
        }

        public void syncButtonsToPage() {
            String backPageId = JWizard.this.current.getBackPageIdentifier();
            String nextPageId = JWizard.this.current.getNextPageIdentifier();
            boolean isValid = JWizard.this.current.isValid();
            JWizard.this.setBackEnabled(backPageId != null);
            if (nextPageId == null) {
                JWizard.this.setNextEnabled(false);
                JWizard.this.setFinishEnabled(false);
            } else if (nextPageId == "Finish") {
                JWizard.this.setNextEnabled(false);
                JWizard.this.setFinishEnabled(isValid);
            } else {
                JWizard.this.setNextEnabled(isValid);
                JWizard.this.setFinishEnabled(false);
            }
        }

        @Override
        public void keyPressed(KeyEvent e) {
        }

        @Override
        public void keyReleased(KeyEvent e) {
            this.syncButtonsToPage();
        }

        @Override
        public void keyTyped(KeyEvent e) {
            this.syncButtonsToPage();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.syncButtonsToPage();
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.syncButtonsToPage();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.syncButtonsToPage();
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            this.syncButtonsToPage();
        }
    }
}

