/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.swing.data;

import java.awt.Component;
import java.awt.HeadlessException;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;
import org.geotools.data.FileDataStoreFactorySpi;
import org.geotools.data.FileDataStoreFinder;

public class JFileDataStoreChooser
extends JFileChooser {
    private static final long serialVersionUID = -7482109609487216939L;

    public JFileDataStoreChooser(String extension) {
        this(new String[]{extension});
    }

    static Map<String, String> associations(List<String> extensions) {
        TreeMap<String, String> fileAssociations = new TreeMap<String, String>();
        for (String extension : extensions) {
            FileDataStoreFactorySpi factory;
            Object ext = extension.toLowerCase().trim();
            if (!((String)ext).startsWith(".")) {
                ext = "." + (String)ext;
            }
            if ((factory = FileDataStoreFinder.getDataStoreFactory((String)ext)) != null) {
                fileAssociations.put((String)ext, factory.getDescription());
                continue;
            }
            if (".csv".equals(ext)) {
                fileAssociations.put((String)ext, "Comma-delimited files (*.csv)");
                continue;
            }
            if (((String)ext).startsWith(".tif")) {
                fileAssociations.put((String)ext, "GeoTIFF files (*.tif; *.tiff)");
                continue;
            }
            fileAssociations.put((String)ext, ((String)ext).toUpperCase().substring(1) + "files (*" + (String)ext + ")");
        }
        return fileAssociations;
    }

    public JFileDataStoreChooser(List<String> extensions) {
        this(JFileDataStoreChooser.associations(extensions));
    }

    public JFileDataStoreChooser(String[] extensions) {
        this(JFileDataStoreChooser.associations(Arrays.asList(extensions)));
    }

    public JFileDataStoreChooser(Map<String, String> fileAssociations) {
        this.init(fileAssociations);
    }

    private void init(final Map<String, String> fileAssociations) {
        for (final String ext : fileAssociations.keySet()) {
            this.addChoosableFileFilter(new FileFilter(){

                @Override
                public boolean accept(File f) {
                    if (f.isDirectory()) {
                        return true;
                    }
                    for (String ext2 : fileAssociations.keySet()) {
                        if (!f.getPath().endsWith(ext2) && !f.getPath().endsWith(ext2.toUpperCase())) continue;
                        return true;
                    }
                    return false;
                }

                @Override
                public String getDescription() {
                    return (String)fileAssociations.get(ext);
                }
            });
        }
    }

    public JFileDataStoreChooser(final FileDataStoreFactorySpi format) {
        this.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File f) {
                if (f.isDirectory()) {
                    return true;
                }
                for (String ext : format.getFileExtensions()) {
                    if (f.getPath().endsWith(ext)) {
                        return true;
                    }
                    if (!f.getPath().endsWith(ext.toUpperCase())) continue;
                    return true;
                }
                return false;
            }

            @Override
            public String getDescription() {
                return format.getDescription();
            }
        });
    }

    public static File showOpenFile(String extension, Component parent) throws HeadlessException {
        return JFileDataStoreChooser.showOpenFile(extension, null, parent);
    }

    public static File showOpenFile(String extension, File initialDir, Component parent) throws HeadlessException {
        JFileDataStoreChooser dialog = new JFileDataStoreChooser(extension);
        if (initialDir != null) {
            if (initialDir.isDirectory()) {
                dialog.setCurrentDirectory(initialDir);
            } else {
                dialog.setCurrentDirectory(initialDir.getParentFile());
            }
        }
        if (dialog.showOpenDialog(parent) == 0) {
            return dialog.getSelectedFile();
        }
        return null;
    }

    public static File showOpenFile(String[] extensions, Component parent) throws HeadlessException {
        return JFileDataStoreChooser.showOpenFile(extensions, null, parent);
    }

    public static File showOpenFile(String[] extensions, File initialDir, Component parent) throws HeadlessException {
        JFileDataStoreChooser dialog = new JFileDataStoreChooser(extensions);
        if (initialDir != null) {
            if (initialDir.isDirectory()) {
                dialog.setCurrentDirectory(initialDir);
            } else {
                dialog.setCurrentDirectory(initialDir.getParentFile());
            }
        }
        if (dialog.showOpenDialog(parent) == 0) {
            return dialog.getSelectedFile();
        }
        return null;
    }

    public static File showOpenFile(FileDataStoreFactorySpi format, Component parent) throws HeadlessException {
        return JFileDataStoreChooser.showOpenFile(format, null, parent);
    }

    public static File showOpenFile(FileDataStoreFactorySpi format, File initialDir, Component parent) throws HeadlessException {
        JFileDataStoreChooser dialog = new JFileDataStoreChooser(format);
        if (initialDir != null) {
            if (initialDir.isDirectory()) {
                dialog.setCurrentDirectory(initialDir);
            } else {
                dialog.setCurrentDirectory(initialDir.getParentFile());
            }
        }
        if (dialog.showOpenDialog(parent) == 0) {
            return dialog.getSelectedFile();
        }
        return null;
    }

    public static void main(String[] arg) {
        File file = JFileDataStoreChooser.showOpenFile("shp", null);
        if (file != null) {
            JOptionPane.showMessageDialog(null, "Selected " + file.getPath());
        } else {
            JOptionPane.showMessageDialog(null, "Selection cancelled");
        }
    }

    public void setSaveFile(File file) {
        String extension;
        String base;
        String path = file.getAbsolutePath();
        int split = path.lastIndexOf(46);
        if (split == -1) {
            base = path;
            extension = "";
        } else {
            base = path.substring(0, split);
            extension = path.substring(split);
        }
        File saveFile = new File(path);
        int number = 0;
        while (saveFile.exists()) {
            saveFile = new File(base + number++ + extension);
        }
        this.setSelectedFile(saveFile);
    }
}

