/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.swing.data;

import java.io.File;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.geotools.data.DataAccessFactory;
import org.geotools.data.DataStoreFactorySpi;
import org.geotools.data.FileDataStoreFinder;
import org.geotools.swing.data.JDataChoosePage;
import org.geotools.swing.data.JDataStorePage;
import org.geotools.swing.wizard.JWizard;
import org.geotools.util.URLs;

public class JDataStoreWizard
extends JWizard {
    private static final long serialVersionUID = -3788708439279424698L;
    DataStoreFactorySpi format;
    private JDataChoosePage page0;
    private JDataStorePage page1;
    private JDataStorePage page2;
    protected Map<String, Object> connectionParameters;

    public JDataStoreWizard() {
        this(null, new HashMap());
    }

    public JDataStoreWizard(String extension) {
        this((DataStoreFactorySpi)(extension == null ? null : FileDataStoreFinder.getDataStoreFactory((String)extension)));
    }

    public JDataStoreWizard(DataStoreFactorySpi format) {
        this(format, new HashMap());
    }

    public JDataStoreWizard(DataStoreFactorySpi format, Map params) {
        super(format == null ? "Connect" : format.getDisplayName());
        this.connectionParameters = params == null ? new HashMap<String, Object>() : params;
        if (format == null) {
            this.page0 = new JDataChoosePage();
            this.page0.setPageIdentifier("page0");
            this.page0.setNextPageIdentifier("page1");
            this.registerWizardPanel(this.page0);
        }
        this.fillInDefaults(format, params);
        this.format = format;
        this.page1 = new JDataStorePage(format, this.connectionParameters);
        this.page1.setLevel("user");
        this.page1.setPageIdentifier("page1");
        if (this.page0 != null) {
            this.page1.setBackPageIdentifier("page0");
        }
        this.registerWizardPanel(this.page1);
        if (this.countParamsAtLevel(format, "advanced") != 0) {
            this.page2 = new JDataStorePage(format, this.connectionParameters);
            this.page2.setPageIdentifier("page2");
            this.page2.setBackPageIdentifier("page1");
            this.page2.setLevel("advanced");
            this.registerWizardPanel(this.page2);
            this.page1.setNextPageIdentifier("page2");
        }
        if (this.page0 != null) {
            this.setCurrentPanel("page0");
        } else {
            this.setCurrentPanel("page1");
        }
    }

    private void fillInDefaults(DataStoreFactorySpi format, Map<String, Object> params) {
        if (format == null) {
            return;
        }
        for (DataAccessFactory.Param param : format.getParametersInfo()) {
            if (!param.required || !"program".equals(param.getLevel()) || params.containsKey(param.key)) continue;
            params.put(param.key, param.sample);
        }
    }

    private int countParamsAtLevel(DataStoreFactorySpi format, String level) {
        if (format == null) {
            return 0;
        }
        int count = 0;
        DataAccessFactory.Param[] parametersInfo = format.getParametersInfo();
        if (level == null) {
            return parametersInfo.length;
        }
        for (DataAccessFactory.Param param : parametersInfo) {
            String check = param.getLevel();
            if (!level.equals(check)) continue;
            ++count;
        }
        return count;
    }

    public Map<String, Object> getConnectionParameters() {
        return this.connectionParameters;
    }

    public File getFile() {
        URL url = (URL)this.connectionParameters.get("url");
        return URLs.urlToFile((URL)url);
    }

    public void setFormat(DataStoreFactorySpi format) {
        if (this.format == format) {
            return;
        }
        if (this.connectionParameters.isEmpty()) {
            this.fillInDefaults(format, this.connectionParameters);
        }
        if (this.page1 != null) {
            this.page1.setFormat(format);
        }
        if (this.page2 != null) {
            this.page2.setFormat(format);
        }
    }
}

