/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.swing.data;

import java.awt.Component;
import java.awt.Font;
import java.awt.LayoutManager;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;
import org.geotools.data.DataAccessFactory;
import org.geotools.data.DataStoreFactorySpi;
import org.geotools.swing.wizard.JPage;
import org.geotools.swing.wizard.ParamField;

public class JDataStorePage
extends JPage {
    protected DataStoreFactorySpi format;
    private Map<DataAccessFactory.Param, ParamField> fields = new HashMap<DataAccessFactory.Param, ParamField>();
    protected Map<String, Object> connectionParameters;
    private String level = null;
    private static final int MAX_DESCRIPTION_WIDTH = 60;

    public JDataStorePage(DataStoreFactorySpi format) {
        this(format, null);
    }

    public JDataStorePage(DataStoreFactorySpi format, Map<String, Object> params) {
        this.format = format;
        if (params == null) {
            params = new HashMap<String, Object>();
            if (format != null) {
                for (DataAccessFactory.Param param : format.getParametersInfo()) {
                    params.put(param.key, param.sample);
                }
            }
        }
        this.connectionParameters = params;
    }

    public void setLevel(String level) {
        this.level = level;
    }

    public void setFormat(DataStoreFactorySpi format) {
        if (this.format != format) {
            this.format = format;
        }
    }

    @Override
    public JPanel createPanel() {
        JPanel page = super.createPanel();
        page.setLayout((LayoutManager)new MigLayout());
        JLabel title = new JLabel(this.format.getDisplayName());
        Font titleFont = new Font("Arial", 1, 14);
        title.setFont(titleFont);
        page.add((Component)title, "span");
        JLabel description = new JLabel(this.format.getDescription());
        page.add((Component)description, "grow, span");
        for (DataAccessFactory.Param param : this.format.getParametersInfo()) {
            if (this.level != null) {
                String check;
                String string = check = param.metadata == null ? "user" : (String)param.metadata.get("level");
                if (check == null) {
                    check = "user";
                }
                if (!this.level.equals(check)) continue;
            }
            Object txt = param.title.toString();
            if (param.required) {
                txt = (String)txt + "*";
            }
            JLabel label = new JLabel((String)txt);
            page.add(label);
            ParamField field = ParamField.create(param);
            JComponent component = field.doLayout();
            page.add((Component)component, "span, wrap");
            this.fields.put(param, field);
            if (param.description == null) continue;
            JLabel info = new JLabel(this.formatDescription(param.description.toString()));
            page.add((Component)info, "skip, span, wrap");
        }
        return page;
    }

    @Override
    public void preDisplayPanel() {
        for (Map.Entry<DataAccessFactory.Param, ParamField> entry : this.fields.entrySet()) {
            DataAccessFactory.Param param = entry.getKey();
            ParamField field = entry.getValue();
            Object value = null;
            try {
                value = param.lookUp(this.connectionParameters);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (value == null && param.required) {
                value = param.sample;
            }
            field.setValue(value);
        }
        for (Map.Entry<DataAccessFactory.Param, ParamField> entry : this.fields.entrySet()) {
            ParamField field = entry.getValue();
            field.addListener(this.getJWizard().getController());
        }
    }

    @Override
    public void preClosePanel() {
        for (Map.Entry<DataAccessFactory.Param, ParamField> entry : this.fields.entrySet()) {
            DataAccessFactory.Param param = entry.getKey();
            ParamField field = entry.getValue();
            Object value = field.getValue();
            this.connectionParameters.put(param.key, value);
            field.setValue(value);
        }
        for (Map.Entry<DataAccessFactory.Param, ParamField> entry : this.fields.entrySet()) {
            ParamField field = entry.getValue();
            field.removeListener(this.getJWizard().getController());
        }
    }

    @Override
    public boolean isValid() {
        for (Map.Entry<DataAccessFactory.Param, ParamField> entry : this.fields.entrySet()) {
            if (entry.getValue().validate()) continue;
            return false;
        }
        return true;
    }

    private String formatDescription(String desc) {
        String prefix = "<html>";
        int LEN = desc.length();
        if (LEN < 60) {
            return prefix + desc;
        }
        StringBuffer sb = new StringBuffer(prefix);
        StringTokenizer tokenizer = new StringTokenizer(desc);
        int n = 0;
        while (tokenizer.hasMoreTokens()) {
            String word = tokenizer.nextToken();
            if (n + word.length() + 1 > 60) {
                sb.append("<br>");
                n = 0;
            }
            sb.append(word);
            sb.append(' ');
            n += word.length() + 1;
        }
        return sb.toString();
    }
}

