/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.swing.data;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import net.miginfocom.swing.MigLayout;
import org.geotools.data.DataStoreFactorySpi;
import org.geotools.data.DataStoreFinder;
import org.geotools.swing.data.JDataStoreWizard;
import org.geotools.swing.wizard.JPage;

public class JDataChoosePage
extends JPage {
    protected DataStoreFactorySpi format;
    private JList<DataStoreFactorySpi> list;

    public JDataChoosePage() {
        this((DataStoreFactorySpi)null);
    }

    public JDataChoosePage(DataStoreFactorySpi format) {
        this.format = format;
    }

    @Override
    public JPanel createPanel() {
        JPanel page = super.createPanel();
        page.setLayout((LayoutManager)new MigLayout());
        JLabel title = new JLabel("Choose DataStore");
        Font titleFont = new Font("Arial", 1, 14);
        title.setFont(titleFont);
        page.add((Component)title, "span");
        JLabel description = new JLabel("Available DataStores on your classpath");
        page.add((Component)description, "grow, span");
        ArrayList<DataStoreFactorySpi> factoryList = new ArrayList<DataStoreFactorySpi>();
        Iterator iter = DataStoreFinder.getAvailableDataStores();
        while (iter.hasNext()) {
            factoryList.add((DataStoreFactorySpi)iter.next());
        }
        this.list = new JList<DataStoreFactorySpi>(factoryList.toArray(new DataStoreFactorySpi[factoryList.size()]));
        DefaultListCellRenderer cellRenderer = new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                DataStoreFactorySpi factory = (DataStoreFactorySpi)value;
                this.setText(factory.getDisplayName());
                this.setToolTipText(factory.getDescription());
                return this;
            }
        };
        this.list.setCellRenderer(cellRenderer);
        this.list.addListSelectionListener(e -> {
            this.format = this.list.getSelectedValue();
        });
        JScrollPane scroll = new JScrollPane(this.list);
        scroll.setVerticalScrollBarPolicy(22);
        scroll.setPreferredSize(new Dimension(300, 100));
        page.add((Component)scroll, "growx,growy,span");
        return page;
    }

    @Override
    public void preDisplayPanel() {
        this.list.addListSelectionListener(this.getJWizard().getController());
    }

    @Override
    public void preClosePanel() {
        this.list.addListSelectionListener(this.getJWizard().getController());
        JDataStoreWizard dataStoreWizard = (JDataStoreWizard)this.getJWizard();
        dataStoreWizard.setFormat(this.format);
    }

    @Override
    public boolean isValid() {
        return this.format != null;
    }
}

