/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.swing.control;

import java.awt.Dimension;
import java.awt.FontMetrics;
import java.util.Arrays;
import javax.swing.JLabel;
import org.geotools.geometry.DirectPosition2D;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.geotools.swing.MapPane;
import org.geotools.swing.control.JMapStatusBar;
import org.geotools.swing.control.StatusBarItem;
import org.geotools.swing.event.MapMouseAdapter;
import org.geotools.swing.event.MapMouseEvent;
import org.geotools.swing.event.MapPaneAdapter;
import org.geotools.swing.event.MapPaneEvent;
import org.geotools.swing.locale.LocaleUtils;
import org.opengis.geometry.Envelope;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class JCoordsStatusBarItem
extends StatusBarItem {
    private static final String COMPONENT_NAME = LocaleUtils.getValue("StatusBar", "CoordsItemName");
    private static final String TOOL_TIP = LocaleUtils.getValue("StatusBar", "CoordsTooltip");
    private static final int DEFAULT_NUM_INTEGER_DIGITS = 3;
    private static final String NO_COORDS = LocaleUtils.getValue("StatusBar", "CoordsNone");
    private final JLabel label;
    private int intLen;
    private int decLen;
    private String numFormat;

    public JCoordsStatusBarItem(MapPane mapPane) {
        super(COMPONENT_NAME);
        if (mapPane == null) {
            throw new IllegalArgumentException("mapPane must not be null");
        }
        this.label = new JLabel();
        this.label.setFont(JMapStatusBar.DEFAULT_FONT);
        this.add(this.label);
        this.setToolTipText(TOOL_TIP);
        this.decLen = 2;
        this.setFormat(mapPane.getDisplayArea());
        mapPane.addMouseListener(new MapMouseAdapter(){

            @Override
            public void onMouseEntered(MapMouseEvent ev) {
                JCoordsStatusBarItem.this.displayCoords(ev.getWorldPos());
            }

            @Override
            public void onMouseExited(MapMouseEvent ev) {
                JCoordsStatusBarItem.this.displayNoCursor();
            }

            @Override
            public void onMouseMoved(MapMouseEvent ev) {
                JCoordsStatusBarItem.this.displayCoords(ev.getWorldPos());
            }
        });
        mapPane.addMapPaneListener(new MapPaneAdapter(){

            @Override
            public void onDisplayAreaChanged(MapPaneEvent ev) {
                JCoordsStatusBarItem.this.setFormat((ReferencedEnvelope)ev.getData());
            }
        });
        this.displayNoCursor();
    }

    @Override
    public void setNumDecimals(int numDecimals) {
        this.decLen = numDecimals;
        this.setLabelSizeAndFormat();
    }

    private void displayCoords(DirectPosition2D p) {
        this.label.setText(String.format(this.numFormat, p.getX(), p.getY()));
        this.ensureMinLabelWidth();
    }

    private void displayNoCursor() {
        this.label.setText(NO_COORDS);
    }

    private void setFormat(ReferencedEnvelope env) {
        if (env == null || env.isEmpty()) {
            this.intLen = 3;
        } else {
            this.setIntegerLen((Envelope)env);
        }
        this.setLabelSizeAndFormat();
    }

    private void setLabelSizeAndFormat() {
        int minLabelWidth = this.getStringWidth();
        Dimension labelSize = this.label.getSize();
        if (labelSize.width < minLabelWidth) {
            this.label.setMinimumSize(new Dimension(minLabelWidth, labelSize.height));
            this.revalidate();
        }
        StringBuilder sb = new StringBuilder();
        sb.append("%").append(this.intLen).append(".").append(this.decLen).append("f, ");
        sb.append("%").append(this.intLen).append(".").append(this.decLen).append("f");
        this.numFormat = sb.toString();
    }

    private int getStringWidth() {
        FontMetrics fm = this.label.getFontMetrics(this.label.getFont());
        char[] c = new char[this.intLen + this.decLen + 1];
        Arrays.fill(c, '0');
        Object s = String.valueOf(c);
        s = (String)s + ", " + (String)s;
        return fm.stringWidth((String)s);
    }

    private void setIntegerLen(Envelope env) {
        int len = -1;
        if (env != null) {
            Envelope validExtent;
            CoordinateReferenceSystem crs = env.getCoordinateReferenceSystem();
            if (crs != null && (validExtent = CRS.getEnvelope((CoordinateReferenceSystem)crs)) != null) {
                len = this.getMaxIntegerLen(validExtent);
            }
            if (len < 0) {
                len = this.getMaxIntegerLen(env);
            }
        } else {
            len = 3;
        }
        this.intLen = len;
    }

    private int getMaxIntegerLen(Envelope env) {
        int len = this.integerPartLen(env.getMinimum(0));
        len = Math.max(len, this.integerPartLen(env.getMinimum(1)));
        len = Math.max(len, this.integerPartLen(env.getMaximum(0)));
        len = Math.max(len, this.integerPartLen(env.getMaximum(1)));
        return len + 1;
    }

    private int integerPartLen(double x) {
        return 1 + (int)Math.log10(Math.abs(x));
    }

    private void ensureMinLabelWidth() {
        Dimension minDim = this.label.getMinimumSize();
        Dimension curDim = this.label.getSize();
        if (curDim.width > minDim.width) {
            this.label.setMinimumSize(new Dimension(curDim.width, minDim.height));
        }
    }
}

