/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.style.svg;

import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.util.Map;
import org.apache.batik.gvt.CompositeGraphicsNode;
import org.apache.batik.gvt.GraphicsNode;
import org.apache.batik.gvt.ShapeNode;
import org.geotools.geometry.jts.TransformedShape;
import org.geotools.renderer.style.MarkFactory;
import org.geotools.renderer.style.svg.RenderableSVG;
import org.geotools.renderer.style.svg.RenderableSVGCache;
import org.opengis.feature.Feature;
import org.opengis.filter.expression.Expression;

public class SVGMarkFactory
implements MarkFactory {
    private RenderableSVGCache cache;

    public SVGMarkFactory() {
        this.cache = new RenderableSVGCache();
    }

    public SVGMarkFactory(Map<RenderingHints.Key, Object> hints) {
        this.cache = new RenderableSVGCache(hints);
    }

    public Shape getShape(Graphics2D graphics, Expression symbolUrl, Feature feature) throws Exception {
        RenderableSVG svg = this.cache.getRenderableSVG(feature, symbolUrl, "image/svg");
        if (svg == null) {
            return null;
        }
        Shape shape = this.getShape(svg.node);
        Rectangle2D bounds = shape.getBounds2D();
        double maxSize = Math.max(bounds.getWidth(), bounds.getHeight());
        double scaleToOne = 1.0 / maxSize;
        AffineTransform at = new AffineTransform(scaleToOne, 0.0, 0.0, -scaleToOne, -0.5, 0.5);
        TransformedShape ts = new TransformedShape(shape, at);
        return ts;
    }

    private Shape getShape(GraphicsNode node) {
        if (!node.isVisible()) {
            return null;
        }
        Shape result = null;
        if (node instanceof ShapeNode) {
            result = ((ShapeNode)node).getShape();
        } else if (node instanceof CompositeGraphicsNode) {
            CompositeGraphicsNode composite = (CompositeGraphicsNode)node;
            for (Object object : composite.getChildren()) {
                Shape subShape = this.getShape((GraphicsNode)object);
                if (subShape == null) continue;
                if (result == null) {
                    result = subShape;
                    continue;
                }
                GeneralPath gp = new GeneralPath();
                gp.append(result.getPathIterator(new AffineTransform()), false);
                gp.append(subShape.getPathIterator(new AffineTransform()), false);
                result = gp;
            }
        }
        AffineTransform transform = node.getTransform();
        if (result != null && transform != null && !transform.isIdentity()) {
            result = new TransformedShape(result, transform);
        }
        return result;
    }
}

