/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.stac.store;

import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.util.Arrays;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang3.tuple.Pair;
import org.geotools.api.data.FeatureReader;
import org.geotools.api.data.Query;
import org.geotools.api.data.QueryCapabilities;
import org.geotools.api.data.SimpleFeatureReader;
import org.geotools.api.feature.FeatureVisitor;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.feature.type.FeatureTypeFactory;
import org.geotools.api.filter.Filter;
import org.geotools.api.filter.FilterFactory;
import org.geotools.api.filter.expression.PropertyName;
import org.geotools.api.filter.sort.SortBy;
import org.geotools.api.filter.sort.SortOrder;
import org.geotools.data.DataUtilities;
import org.geotools.data.MaxFeatureReader;
import org.geotools.data.ReTypeFeatureReader;
import org.geotools.data.collection.ListFeatureCollection;
import org.geotools.data.geojson.PagingFeatureCollection;
import org.geotools.data.simple.FilteringSimpleFeatureReader;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.store.ContentEntry;
import org.geotools.data.store.ContentFeatureCollection;
import org.geotools.data.store.ContentFeatureSource;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.feature.visitor.MaxVisitor;
import org.geotools.feature.visitor.MinVisitor;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.stac.client.STACClient;
import org.geotools.stac.client.SearchQuery;
import org.geotools.stac.store.AssetsMappingReader;
import org.geotools.stac.store.CollectionReader;
import org.geotools.stac.store.STACDataStore;
import org.geotools.stac.store.STACFeatureTypeFactoryImpl;
import org.geotools.stac.store.SearchQueryBuilder;
import org.geotools.util.factory.Hints;

public class STACFeatureSource
extends ContentFeatureSource {
    static final FilterFactory FF = CommonFactoryFinder.getFilterFactory();
    static final String ASSETS = "assets";
    private final STACClient client;
    private final SearchQueryBuilder queryBuilder;

    public STACFeatureSource(ContentEntry entry, STACClient client) {
        super(entry, Query.ALL);
        this.client = client;
        this.queryBuilder = new SearchQueryBuilder(this.getSchema(), this.getDataStore());
    }

    public STACDataStore getDataStore() {
        return (STACDataStore)super.getDataStore();
    }

    protected QueryCapabilities buildQueryCapabilities() {
        return new QueryCapabilities(){

            public boolean isOffsetSupported() {
                return false;
            }

            public boolean supportsSorting(SortBy ... sortAttributes) {
                return false;
            }
        };
    }

    protected void addHints(Set<Hints.Key> hints) {
        hints.add(Hints.FEATURE_DETACHED);
    }

    protected ReferencedEnvelope getBoundsInternal(Query query) throws IOException {
        if (!query.equals((Object)Query.ALL)) {
            return null;
        }
        String typeName = this.getCollectionId(query);
        return this.client.getCollections().stream().filter(c -> typeName.equals(c.getId())).map(c -> c.getBounds()).findFirst().orElse(null);
    }

    protected int getCountInternal(Query query) throws IOException {
        Pair<SearchQuery, Filter> pair = this.queryBuilder.toSearchQuery(query, true);
        if (pair == null) {
            return -1;
        }
        Integer fc = this.getCountFromClient((SearchQuery)pair.getKey());
        if (fc != null) {
            int hardLimit = this.getDataStore().getHardLimit();
            if (hardLimit > 0) {
                return Math.min(hardLimit, fc);
            }
            return fc;
        }
        return -1;
    }

    private Integer getCountFromClient(SearchQuery searchQuery) throws IOException {
        SimpleFeatureCollection fc = this.client.search(searchQuery, this.getDataStore().getSearchMode());
        if (fc instanceof PagingFeatureCollection) {
            return Optional.ofNullable(((PagingFeatureCollection)fc).getMatched()).orElse(-1);
        }
        if (fc instanceof ListFeatureCollection) {
            return fc.size();
        }
        return null;
    }

    protected SimpleFeatureType buildFeatureType() throws IOException {
        Query q = new Query();
        q.setTypeName(this.entry.getTypeName());
        SearchQueryBuilder builder = new SearchQueryBuilder(null, this.getDataStore());
        SearchQuery sq = (SearchQuery)builder.toSearchQuery(q, false).getKey();
        sq.setLimit(this.getDataStore().getFeatureTypeItems());
        SimpleFeatureCollection fc = this.client.search(sq, this.getDataStore().getSearchMode());
        SimpleFeatureType rawSchema = (SimpleFeatureType)fc.getSchema();
        SimpleFeatureTypeBuilder tb = new SimpleFeatureTypeBuilder((FeatureTypeFactory)new STACFeatureTypeFactoryImpl());
        tb.init(rawSchema);
        tb.add(ASSETS, ObjectNode.class);
        tb.setName(this.entry.getTypeName());
        return tb.buildFeatureType();
    }

    private String getCollectionId(Query query) {
        return Optional.ofNullable(query).map(q -> q.getTypeName()).orElse(this.entry.getTypeName());
    }

    protected boolean canFilter(Query query) {
        return true;
    }

    protected boolean canSort(Query query) {
        return true;
    }

    protected boolean canRetype(Query query) {
        return true;
    }

    protected boolean canLimit(Query query) {
        return true;
    }

    protected FeatureReader<SimpleFeatureType, SimpleFeature> getReaderInternal(Query query) throws IOException {
        int max;
        int hardLimit;
        Filter postFilter;
        SearchQuery sq;
        Pair<SearchQuery, Filter> pair = this.queryBuilder.toSearchQuery(query, false);
        if (pair == null) {
            sq = (SearchQuery)this.queryBuilder.toSearchQuery(Query.ALL, false).getKey();
            postFilter = query.getFilter();
        } else {
            sq = (SearchQuery)pair.getKey();
            postFilter = (Filter)pair.getValue();
        }
        SimpleFeatureCollection fc = this.client.search(sq, this.getDataStore().getSearchMode(), this.getSchema());
        Object result = new CollectionReader(fc);
        if (sq.getFields() != null && sq.getFields().stream().anyMatch(f -> STACFeatureSource.usesAssets(f))) {
            result = new AssetsMappingReader(this.getSchema(), (SimpleFeatureReader)result);
        }
        if ((hardLimit = this.getDataStore().getHardLimit()) > 0) {
            result = DataUtilities.simple((FeatureReader)new MaxFeatureReader((FeatureReader)result, hardLimit));
        }
        if (!Filter.INCLUDE.equals(postFilter)) {
            result = new FilteringSimpleFeatureReader((SimpleFeatureReader)result, query.getFilter());
        }
        if (!(query.getProperties() == null || query.getProperties().isEmpty() || sq.getFields() != null && Filter.INCLUDE.equals(postFilter))) {
            SimpleFeatureType targetType = SimpleFeatureTypeBuilder.retype((SimpleFeatureType)this.getSchema(), Arrays.asList(query.getPropertyNames()));
            result = DataUtilities.simple((FeatureReader)new ReTypeFeatureReader((FeatureReader)result, targetType, false));
        }
        if ((max = query.getMaxFeatures()) < Integer.MAX_VALUE) {
            result = DataUtilities.simple((FeatureReader)new MaxFeatureReader((FeatureReader)result, max));
        }
        return result;
    }

    private static boolean usesAssets(String f) {
        return f.equals(ASSETS) || f.startsWith("assets.");
    }

    protected boolean handleVisitor(Query query, FeatureVisitor visitor) throws IOException {
        if (visitor instanceof MinVisitor && ((MinVisitor)visitor).getExpression() instanceof PropertyName) {
            String pn = ((PropertyName)((MinVisitor)visitor).getExpression()).getPropertyName();
            ((MinVisitor)visitor).setValue(this.getExtremeValue(query, pn, SortOrder.ASCENDING));
            return true;
        }
        if (visitor instanceof MaxVisitor && ((MaxVisitor)visitor).getExpression() instanceof PropertyName) {
            String pn = ((PropertyName)((MaxVisitor)visitor).getExpression()).getPropertyName();
            ((MaxVisitor)visitor).setValue(this.getExtremeValue(query, pn, SortOrder.DESCENDING));
            return true;
        }
        return super.handleVisitor(query, visitor);
    }

    private Object getExtremeValue(Query query, String pn, SortOrder direction) throws IOException {
        Query q = new Query(query);
        q.setPropertyNames(new String[]{pn});
        q.setSortBy(new SortBy[]{FF.sort(pn, direction)});
        q.setMaxFeatures(1);
        ContentFeatureCollection fc = this.getFeatures(q);
        SimpleFeature feature = (SimpleFeature)DataUtilities.first((FeatureCollection)fc);
        if (feature == null) {
            return null;
        }
        return feature.getAttribute(pn);
    }
}

