/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.stac.store;

import java.io.IOException;
import java.util.Map;
import java.util.NoSuchElementException;
import org.geotools.api.data.SimpleFeatureReader;
import org.geotools.api.feature.IllegalAttributeException;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.data.geojson.GeoJSONReader;
import org.geotools.feature.simple.SimpleFeatureBuilder;

public class AssetsMappingReader
implements SimpleFeatureReader {
    private final SimpleFeatureReader delegate;
    private final SimpleFeatureBuilder builder;

    public AssetsMappingReader(SimpleFeatureType targetType, SimpleFeatureReader delegate) {
        this.delegate = delegate;
        this.builder = new SimpleFeatureBuilder(targetType);
    }

    public SimpleFeatureType getFeatureType() {
        return this.builder.getFeatureType();
    }

    public boolean hasNext() throws IOException {
        return this.delegate.hasNext();
    }

    public SimpleFeature next() throws IOException, IllegalAttributeException, NoSuchElementException {
        SimpleFeature f = (SimpleFeature)this.delegate.next();
        Object atts = f.getUserData().get(GeoJSONReader.TOP_LEVEL_ATTRIBUTES);
        if (atts instanceof Map) {
            Map attributes = (Map)atts;
            Object assets = attributes.get("assets");
            this.builder.init(f);
            this.builder.set("assets", assets);
            return this.builder.buildFeature(f.getID());
        }
        return f;
    }

    public void close() throws IOException {
        this.delegate.close();
    }
}

