/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.stac.client;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.IOException;
import org.geootols.filter.text.cql_2.CQL2;
import org.geotools.api.filter.Filter;
import org.geotools.filter.text.cqljson.CQL2Json;
import org.geotools.stac.client.FilterLang;
import org.geotools.stac.client.GeometryDefaulter;
import org.geotools.stac.client.SearchQuery;

public class STACFilterSerializer
extends JsonSerializer<Filter> {
    public void serialize(Filter filter, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        FilterLang lang = null;
        Object container = jsonGenerator.currentValue();
        if (container instanceof SearchQuery) {
            lang = ((SearchQuery)container).getFilterLang();
        }
        if (lang == null) {
            lang = FilterLang.CQL2_JSON;
        }
        Filter defaulted = GeometryDefaulter.defaultGeometry(filter);
        if (lang == FilterLang.CQL2_TEXT) {
            jsonGenerator.writeString(CQL2.toCQL2((Filter)defaulted));
        } else if (lang == FilterLang.CQL2_JSON) {
            JsonNode node = CQL2Json.toCQL2Json((Filter)defaulted);
            jsonGenerator.writeObject((Object)node);
        }
    }
}

