/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.stac.client;

import java.util.List;
import java.util.regex.Pattern;

public enum STACConformance {
    CORE("core"),
    COLLECTIONS("collections"),
    FEATURES("ogcapi-features"),
    ITEM_SEARCH("item-search"),
    CONTEXT("item-search#context"),
    FIELDS("item-search#fields"),
    SORT("item-search#sort"),
    QUERY("item-search#query"),
    FILTER("item-search#filter");

    private static final String STAC_PREFIX = "https://api.stacspec.org/v1.0.";
    private final Pattern pattern;

    private STACConformance(String suffix) {
        this.pattern = Pattern.compile(Pattern.quote(STAC_PREFIX) + ".*/" + Pattern.quote(suffix) + ".*");
    }

    public boolean matches(List<String> conformance) {
        return conformance.stream().anyMatch(c -> this.pattern.matcher((CharSequence)c).matches());
    }
}

