/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.stac.store;

import java.util.Date;
import org.geotools.filter.visitor.NullFilterVisitor;
import org.geotools.util.DateRange;
import org.geotools.util.Range;
import org.opengis.filter.And;
import org.opengis.filter.BinaryComparisonOperator;
import org.opengis.filter.ExcludeFilter;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterVisitor;
import org.opengis.filter.Id;
import org.opengis.filter.IncludeFilter;
import org.opengis.filter.Not;
import org.opengis.filter.Or;
import org.opengis.filter.PropertyIsBetween;
import org.opengis.filter.PropertyIsEqualTo;
import org.opengis.filter.PropertyIsGreaterThan;
import org.opengis.filter.PropertyIsGreaterThanOrEqualTo;
import org.opengis.filter.PropertyIsLessThan;
import org.opengis.filter.PropertyIsLessThanOrEqualTo;
import org.opengis.filter.PropertyIsLike;
import org.opengis.filter.PropertyIsNil;
import org.opengis.filter.PropertyIsNotEqualTo;
import org.opengis.filter.PropertyIsNull;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.Literal;
import org.opengis.filter.expression.PropertyName;
import org.opengis.filter.spatial.BBOX;
import org.opengis.filter.spatial.Beyond;
import org.opengis.filter.spatial.Contains;
import org.opengis.filter.spatial.Crosses;
import org.opengis.filter.spatial.DWithin;
import org.opengis.filter.spatial.Disjoint;
import org.opengis.filter.spatial.Equals;
import org.opengis.filter.spatial.Intersects;
import org.opengis.filter.spatial.Overlaps;
import org.opengis.filter.spatial.Touches;
import org.opengis.filter.spatial.Within;
import org.opengis.filter.temporal.After;
import org.opengis.filter.temporal.AnyInteracts;
import org.opengis.filter.temporal.Before;
import org.opengis.filter.temporal.Begins;
import org.opengis.filter.temporal.BegunBy;
import org.opengis.filter.temporal.During;
import org.opengis.filter.temporal.EndedBy;
import org.opengis.filter.temporal.Ends;
import org.opengis.filter.temporal.Meets;
import org.opengis.filter.temporal.MetBy;
import org.opengis.filter.temporal.OverlappedBy;
import org.opengis.filter.temporal.TContains;
import org.opengis.filter.temporal.TEquals;
import org.opengis.filter.temporal.TOverlaps;

public class TimeRangeVisitor
extends NullFilterVisitor {
    public static final Date DATE_NEGATIVE_INFINITE = new Date(Long.MIN_VALUE);
    public static final Date DATE_POSITIVE_INFINITE = new Date(Long.MAX_VALUE);
    static final DateRange INFINITY = new DateRange(DATE_NEGATIVE_INFINITE, false, DATE_POSITIVE_INFINITE, false);
    private static final String DATETIME = "datetime";
    boolean exact = true;
    private String timeProperty = "datetime";

    public String getTimeProperty() {
        return this.timeProperty;
    }

    public void setTimeProperty(String timeProperty) {
        this.timeProperty = timeProperty;
    }

    public boolean isExact() {
        return this.exact;
    }

    public void reset() {
        this.exact = true;
    }

    private boolean isTimeLiteral(Expression ex) {
        return ex instanceof Literal && ex.evaluate(null, Date.class) != null;
    }

    protected boolean isTimeProperty(Expression expression) {
        return expression instanceof PropertyName && this.timeProperty.equals(((PropertyName)expression).getPropertyName());
    }

    private DateRange infinity() {
        this.exact = false;
        return INFINITY;
    }

    public Object visitNullFilter(Object extraData) {
        return this.infinity();
    }

    public Object visit(ExcludeFilter filter, Object extraData) {
        this.exact = false;
        return null;
    }

    public Object visit(IncludeFilter filter, Object extraData) {
        return INFINITY;
    }

    public Object visit(And filter, Object extraData) {
        DateRange mixed = INFINITY;
        for (Filter f : filter.getChildren()) {
            DateRange range = (DateRange)f.accept((FilterVisitor)this, extraData);
            Range in = mixed.intersect((Range)range);
            mixed = this.toDateRange((Range<Date>)in);
        }
        return mixed;
    }

    private DateRange toDateRange(Range<Date> in) {
        return new DateRange((Date)in.getMinValue(), in.isMinIncluded(), (Date)in.getMaxValue(), in.isMaxIncluded());
    }

    public Object visit(Id filter, Object extraData) {
        return this.infinity();
    }

    public Object visit(Not filter, Object extraData) {
        return INFINITY;
    }

    public Object visit(Or filter, Object extraData) {
        DateRange mixed = null;
        for (Filter f : filter.getChildren()) {
            DateRange range = (DateRange)f.accept((FilterVisitor)this, extraData);
            if (range == null) continue;
            if (mixed == null) {
                mixed = range;
                continue;
            }
            this.exact &= mixed.intersects((Range)range);
            Range un = mixed.union((Range)range);
            mixed = this.toDateRange((Range<Date>)un);
        }
        return mixed;
    }

    public Object visit(PropertyIsBetween filter, Object extraData) {
        if (!(this.isTimeProperty(filter.getExpression()) && this.isTimeLiteral(filter.getLowerBoundary()) && this.isTimeLiteral(filter.getUpperBoundary()))) {
            return this.infinity();
        }
        Date low = (Date)filter.getLowerBoundary().evaluate(null, Date.class);
        Date high = (Date)filter.getUpperBoundary().evaluate(null, Date.class);
        return new DateRange(low, high);
    }

    public Object visit(PropertyIsEqualTo filter, Object extraData) {
        boolean p1 = this.isTimeProperty(filter.getExpression1());
        boolean p2 = this.isTimeProperty(filter.getExpression2());
        boolean l1 = this.isTimeLiteral(filter.getExpression1());
        boolean l2 = this.isTimeLiteral(filter.getExpression2());
        if (!(p1 && l2 || p2 && l1)) {
            return this.infinity();
        }
        Date date = p1 && l2 ? (Date)filter.getExpression2().evaluate(null, Date.class) : (Date)filter.getExpression1().evaluate(null, Date.class);
        return new DateRange(date, date);
    }

    public Object visit(PropertyIsNotEqualTo filter, Object extraData) {
        return this.infinity();
    }

    public Object visit(PropertyIsGreaterThan filter, Object extraData) {
        return this.greater((BinaryComparisonOperator)filter, false);
    }

    public Object visit(PropertyIsGreaterThanOrEqualTo filter, Object extraData) {
        return this.greater((BinaryComparisonOperator)filter, true);
    }

    private DateRange greater(BinaryComparisonOperator filter, boolean included) {
        boolean p1 = this.isTimeProperty(filter.getExpression1());
        boolean p2 = this.isTimeProperty(filter.getExpression2());
        boolean l1 = this.isTimeLiteral(filter.getExpression1());
        boolean l2 = this.isTimeLiteral(filter.getExpression2());
        if (!(p1 && l2 || p2 && l1)) {
            return this.infinity();
        }
        if (p1 && l2) {
            Date date = (Date)filter.getExpression2().evaluate(null, Date.class);
            return new DateRange(date, included, DATE_POSITIVE_INFINITE, false);
        }
        Date date = (Date)filter.getExpression1().evaluate(null, Date.class);
        return new DateRange(DATE_NEGATIVE_INFINITE, false, date, included);
    }

    public Object visit(PropertyIsLessThan filter, Object extraData) {
        return this.lesser((BinaryComparisonOperator)filter, false);
    }

    public Object visit(PropertyIsLessThanOrEqualTo filter, Object extraData) {
        return this.lesser((BinaryComparisonOperator)filter, true);
    }

    private DateRange lesser(BinaryComparisonOperator filter, boolean included) {
        boolean p1 = this.isTimeProperty(filter.getExpression1());
        boolean p2 = this.isTimeProperty(filter.getExpression2());
        boolean l1 = this.isTimeLiteral(filter.getExpression1());
        boolean l2 = this.isTimeLiteral(filter.getExpression2());
        if (!(p1 && l2 || p2 && l1)) {
            return this.infinity();
        }
        if (p1 && l2) {
            Date date = (Date)filter.getExpression2().evaluate(null, Date.class);
            return new DateRange(DATE_NEGATIVE_INFINITE, false, date, included);
        }
        Date date = (Date)filter.getExpression1().evaluate(null, Date.class);
        return new DateRange(date, included, DATE_POSITIVE_INFINITE, false);
    }

    public Object visit(PropertyIsLike filter, Object extraData) {
        return this.infinity();
    }

    public Object visit(PropertyIsNull filter, Object extraData) {
        return this.infinity();
    }

    public Object visit(PropertyIsNil filter, Object extraData) {
        return this.infinity();
    }

    public Object visit(BBOX filter, Object extraData) {
        return this.infinity();
    }

    public Object visit(Beyond filter, Object extraData) {
        return this.infinity();
    }

    public Object visit(Contains filter, Object extraData) {
        return this.infinity();
    }

    public Object visit(Crosses filter, Object extraData) {
        return this.infinity();
    }

    public Object visit(Disjoint filter, Object extraData) {
        return this.infinity();
    }

    public Object visit(DWithin filter, Object extraData) {
        return this.infinity();
    }

    public Object visit(Equals filter, Object extraData) {
        return this.infinity();
    }

    public Object visit(Intersects filter, Object extraData) {
        return this.infinity();
    }

    public Object visit(Overlaps filter, Object extraData) {
        return this.infinity();
    }

    public Object visit(Touches filter, Object extraData) {
        return this.infinity();
    }

    public Object visit(Within filter, Object extraData) {
        return this.infinity();
    }

    public Object visit(After filter, Object extraData) {
        boolean p1 = this.isTimeProperty(filter.getExpression1());
        boolean p2 = this.isTimeProperty(filter.getExpression2());
        boolean l1 = this.isTimeLiteral(filter.getExpression1());
        boolean l2 = this.isTimeLiteral(filter.getExpression2());
        if (!(p1 && l2 || p2 && l1)) {
            return this.infinity();
        }
        if (p1 && l2) {
            Date date = (Date)filter.getExpression2().evaluate(null, Date.class);
            return new DateRange(date, false, DATE_POSITIVE_INFINITE, false);
        }
        Date date = (Date)filter.getExpression1().evaluate(null, Date.class);
        return new DateRange(DATE_NEGATIVE_INFINITE, false, date, false);
    }

    public Object visit(AnyInteracts anyInteracts, Object extraData) {
        return this.infinity();
    }

    public Object visit(Before filter, Object extraData) {
        boolean p1 = this.isTimeProperty(filter.getExpression1());
        boolean p2 = this.isTimeProperty(filter.getExpression2());
        boolean l1 = this.isTimeLiteral(filter.getExpression1());
        boolean l2 = this.isTimeLiteral(filter.getExpression2());
        if (!(p1 && l2 || p2 && l1)) {
            return this.infinity();
        }
        if (p1 && l2) {
            Date date = (Date)filter.getExpression2().evaluate(null, Date.class);
            return new DateRange(DATE_NEGATIVE_INFINITE, false, date, false);
        }
        Date date = (Date)filter.getExpression1().evaluate(null, Date.class);
        return new DateRange(date, false, DATE_POSITIVE_INFINITE, false);
    }

    public Object visit(Begins begins, Object extraData) {
        return this.infinity();
    }

    public Object visit(BegunBy begunBy, Object extraData) {
        return this.infinity();
    }

    public Object visit(During during, Object extraData) {
        return this.infinity();
    }

    public Object visit(EndedBy endedBy, Object extraData) {
        return this.infinity();
    }

    public Object visit(Ends ends, Object extraData) {
        return this.infinity();
    }

    public Object visit(Meets meets, Object extraData) {
        return this.infinity();
    }

    public Object visit(MetBy metBy, Object extraData) {
        return this.infinity();
    }

    public Object visit(OverlappedBy overlappedBy, Object extraData) {
        return this.infinity();
    }

    public Object visit(TContains contains, Object extraData) {
        return this.infinity();
    }

    public Object visit(TEquals filter, Object extraData) {
        boolean p1 = this.isTimeProperty(filter.getExpression1());
        boolean p2 = this.isTimeProperty(filter.getExpression2());
        boolean l1 = this.isTimeLiteral(filter.getExpression1());
        boolean l2 = this.isTimeLiteral(filter.getExpression2());
        if (!(p1 && l2 || p2 && l1)) {
            return this.infinity();
        }
        Date date = p1 && l2 ? (Date)filter.getExpression2().evaluate(null, Date.class) : (Date)filter.getExpression1().evaluate(null, Date.class);
        return new DateRange(date, date);
    }

    public Object visit(TOverlaps contains, Object extraData) {
        return this.infinity();
    }
}

