/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.stac.store;

import java.util.Date;
import java.util.Optional;
import org.geotools.filter.visitor.DuplicatingFilterVisitor;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.PropertyIsEqualTo;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.PropertyName;

public class TemporalFilterVisitor
extends DuplicatingFilterVisitor {
    SimpleFeatureType schema;

    public TemporalFilterVisitor(SimpleFeatureType schema) {
        this.schema = schema;
    }

    public Object visit(PropertyIsEqualTo filter, Object extraData) {
        if (this.isTimeProperty(filter.getExpression1()) || this.isTimeProperty(filter.getExpression2())) {
            return this.ff.tequals(filter.getExpression1(), filter.getExpression2());
        }
        return super.visit(filter, extraData);
    }

    protected boolean isTimeProperty(Expression expression) {
        if (!(expression instanceof PropertyName)) {
            return false;
        }
        String name = ((PropertyName)expression).getPropertyName();
        return Optional.ofNullable(name).map(n -> this.schema.getDescriptor(name)).map(d -> d.getType().getBinding()).filter(c -> Date.class.isAssignableFrom((Class<?>)c)).isPresent();
    }
}

