/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.stac.store;

import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;
import org.geotools.data.Query;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.filter.FilterAttributeExtractor;
import org.geotools.filter.visitor.SimplifyingFilterVisitor;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.stac.client.CQL2Conformance;
import org.geotools.stac.client.FilterLang;
import org.geotools.stac.client.STACClient;
import org.geotools.stac.client.STACConformance;
import org.geotools.stac.client.SearchQuery;
import org.geotools.stac.client.SortBy;
import org.geotools.stac.store.CQL2PostPreFilterSplitter;
import org.geotools.stac.store.STACDataStore;
import org.geotools.stac.store.TemporalFilterVisitor;
import org.geotools.stac.store.TimeRangeVisitor;
import org.geotools.util.DateRange;
import org.locationtech.jts.geom.Envelope;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.And;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.FilterVisitor;
import org.opengis.filter.IncludeFilter;
import org.opengis.filter.sort.SortBy;
import org.opengis.filter.sort.SortOrder;
import org.opengis.filter.spatial.BBOX;
import org.opengis.filter.temporal.BinaryTemporalOperator;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.TransformException;

class SearchQueryBuilder {
    static final FilterFactory2 FF = CommonFactoryFinder.getFilterFactory2();
    private static final ReferencedEnvelope WORLD = new ReferencedEnvelope(-180.0, 180.0, -90.0, 90.0, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
    private static final String TYPE = "type";
    private static final String ID = "id";
    private static final String BBOX = "bbox";
    private static final String GEOMETRY = "geometry";
    private final SimpleFeatureType schema;
    private final STACDataStore store;

    public SearchQueryBuilder(SimpleFeatureType schema, STACDataStore store) {
        this.schema = schema;
        this.store = store;
    }

    public Pair<SearchQuery, Filter> toSearchQuery(Query q, boolean strict) {
        String[] propertyNames;
        SearchQuery sq = new SearchQuery();
        sq.setCollections(Arrays.asList(this.getCollectionId(q)));
        sq.setLimit(Math.min(q.getMaxFeatures(), this.store.getFetchSize()));
        List<String> conformance = this.store.getClient().getLandingPage().getConformance();
        if (q.getSortBy() != null && q.getSortBy() != SortBy.UNSORTED && STACConformance.SORT.matches(conformance)) {
            List<org.geotools.stac.client.SortBy> sorts = Arrays.stream(q.getSortBy()).map(sb -> this.toSTACSort((SortBy)sb)).collect(Collectors.toList());
            sq.setSortBy(sorts);
        }
        if (q.getJoins() != null && !q.getJoins().isEmpty() && strict) {
            return null;
        }
        IncludeFilter post = Filter.INCLUDE;
        if (q.getFilter() != null && q.getFilter() != Filter.INCLUDE) {
            Filter simplified = SimplifyingFilterVisitor.simplify((Filter)q.getFilter());
            try {
                if (!this.encodeSimpleFilter(simplified, sq)) {
                    Filter adapted;
                    if (!STACConformance.FILTER.matches(conformance)) {
                        return null;
                    }
                    TemporalFilterVisitor temporalReplacer = new TemporalFilterVisitor(this.schema);
                    Object leftover = adapted = (Filter)simplified.accept((FilterVisitor)temporalReplacer, null);
                    if (adapted instanceof And) {
                        ArrayList<BBOX> bbox = new ArrayList<BBOX>();
                        ArrayList<BinaryTemporalOperator> time = new ArrayList<BinaryTemporalOperator>();
                        ArrayList<Filter> other = new ArrayList<Filter>();
                        for (Filter filter : ((And)adapted).getChildren()) {
                            if (filter instanceof BBOX) {
                                bbox.add((BBOX)filter);
                                continue;
                            }
                            if (filter instanceof BinaryTemporalOperator) {
                                time.add((BinaryTemporalOperator)filter);
                                continue;
                            }
                            other.add(filter);
                        }
                        if (time.size() <= 1 && bbox.size() <= 1 && time.size() + bbox.size() <= 2 && time.size() + bbox.size() > 0) {
                            if (!time.isEmpty()) {
                                this.encodeTimeFilter((Filter)time.get(0), sq);
                            }
                            if (!bbox.isEmpty()) {
                                this.encodeBBOX((BBOX)bbox.get(0), sq);
                            }
                            leftover = other.isEmpty() ? Filter.EXCLUDE : (other.size() == 1 ? (Filter)other.get(0) : FF.and(other));
                        }
                    }
                    if (!Filter.EXCLUDE.equals(leftover)) {
                        CQL2PostPreFilterSplitter splitter = new CQL2PostPreFilterSplitter(conformance);
                        leftover.accept((FilterVisitor)splitter, null);
                        Filter pre = splitter.getFilterPre();
                        post = splitter.getFilterPost();
                        if (strict && !Filter.INCLUDE.equals(post)) {
                            return null;
                        }
                        if (this.setupFilterLanguage(sq, conformance)) {
                            sq.setFilter(pre);
                        }
                    }
                }
            }
            catch (FactoryException | TransformException e) {
                throw new RuntimeException("Failed to setup the bbox filter", e);
            }
        }
        if ((propertyNames = q.getPropertyNames()) != null && !q.getProperties().isEmpty()) {
            if (STACConformance.FIELDS.matches(conformance)) {
                LinkedHashSet<String> nameList = new LinkedHashSet<String>(Arrays.asList(propertyNames));
                if (post != null && !Filter.INCLUDE.equals(post)) {
                    FilterAttributeExtractor fex = new FilterAttributeExtractor();
                    post.accept((FilterVisitor)fex, null);
                    nameList.addAll(fex.getAttributeNameSet());
                }
                List<String> fields = nameList.stream().map(n -> SearchQueryBuilder.propertyToField(n)).map(n -> n.replace('/', '.')).collect(Collectors.toList());
                fields.add(TYPE);
                fields.add(ID);
                fields.add("-bbox");
                if (nameList.stream().noneMatch(n -> n.startsWith("properties"))) {
                    fields.add("-properties");
                }
                if (fields.stream().noneMatch(n -> n.equals("assets"))) {
                    fields.add("-assets");
                }
                fields.add("-links");
                sq.setFields(fields);
            } else if (strict) {
                return null;
            }
        }
        return Pair.of((Object)sq, (Object)post);
    }

    private static String propertyToField(String n) {
        return n.equals(GEOMETRY) || n.equals("assets") || n.startsWith("assets/") ? n : "properties." + n;
    }

    private String getCollectionId(Query query) {
        if (query != null && query.getTypeName() != null) {
            return query.getTypeName();
        }
        return this.schema.getTypeName();
    }

    private boolean setupFilterLanguage(SearchQuery sq, List<String> conformance) {
        boolean text = CQL2Conformance.TEXT.matches(conformance);
        boolean json = CQL2Conformance.JSON.matches(conformance);
        if (text && json) {
            if (this.store.getSearchMode().equals((Object)STACClient.SearchMode.GET)) {
                sq.setFilterLang(FilterLang.CQL2_TEXT);
            } else {
                sq.setFilterLang(FilterLang.CQL2_JSON);
            }
        } else if (text) {
            sq.setFilterLang(FilterLang.CQL2_TEXT);
        } else if (json) {
            sq.setFilterLang(FilterLang.CQL2_JSON);
        }
        return sq.getFilterLang() != null;
    }

    private org.geotools.stac.client.SortBy toSTACSort(SortBy sort) {
        return new org.geotools.stac.client.SortBy(sort.getPropertyName().getPropertyName(), sort.getSortOrder() == SortOrder.DESCENDING ? SortBy.Direction.desc : SortBy.Direction.asc);
    }

    private boolean encodeSimpleFilter(Filter filter, SearchQuery sq) throws FactoryException, TransformException {
        if (filter instanceof BBOX) {
            this.encodeBBOX((BBOX)filter, sq);
            return true;
        }
        if (this.isTimeFilter(filter)) {
            this.encodeTimeFilter(filter, sq);
            return true;
        }
        if (filter instanceof And) {
            And and = (And)filter;
            List children = and.getChildren();
            if (children.size() != 2) {
                return false;
            }
            if (children.get(0) instanceof BBOX && this.isTimeFilter((Filter)children.get(1))) {
                this.encodeBBOX((BBOX)children.get(0), sq);
                this.encodeTimeFilter((Filter)children.get(1), sq);
                return true;
            }
            if (children.get(1) instanceof BBOX && this.isTimeFilter((Filter)children.get(0))) {
                this.encodeBBOX((BBOX)children.get(1), sq);
                this.encodeTimeFilter((Filter)children.get(0), sq);
                return true;
            }
        }
        return false;
    }

    private void encodeTimeFilter(Filter filter, SearchQuery sq) {
        TimeRangeVisitor visitor = new TimeRangeVisitor();
        DateRange range = (DateRange)filter.accept((FilterVisitor)visitor, null);
        if (TimeRangeVisitor.DATE_NEGATIVE_INFINITE.equals(range.getMinValue())) {
            if (TimeRangeVisitor.DATE_POSITIVE_INFINITE.equals(range.getMaxValue())) {
                return;
            }
            sq.setDatetime("../" + this.toISO(range.getMaxValue()));
        } else if (TimeRangeVisitor.DATE_POSITIVE_INFINITE.equals(range.getMaxValue())) {
            sq.setDatetime(this.toISO(range.getMinValue()) + "/..");
        } else if (range.getMinValue().equals(range.getMaxValue())) {
            long next = range.getMinValue().getTime() + 1L;
            sq.setDatetime(this.toISO(range.getMinValue()) + "/" + this.toISO(new Date(next)));
        } else {
            sq.setDatetime(this.toISO(range.getMinValue()) + "/" + this.toISO(range.getMaxValue()));
        }
    }

    private String toISO(Date value) {
        return DateTimeFormatter.ISO_INSTANT.format(value.toInstant());
    }

    private boolean isTimeFilter(Filter filter) {
        TimeRangeVisitor visitor = new TimeRangeVisitor();
        DateRange range = (DateRange)filter.accept((FilterVisitor)visitor, null);
        return range != null && !range.isEmpty() && !TimeRangeVisitor.INFINITY.equals((Object)range) && visitor.isExact();
    }

    private void encodeBBOX(BBOX filter, SearchQuery sq) throws TransformException, FactoryException {
        ReferencedEnvelope box = ReferencedEnvelope.reference((org.opengis.geometry.Envelope)filter.getBounds()).transform((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84, true);
        box = box.intersection((Envelope)WORLD);
        sq.setBbox(new double[]{box.getMinX(), box.getMinY(), box.getMaxX(), box.getMaxY()});
    }
}

