/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.stac.store;

import java.awt.RenderingHints;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import org.geotools.data.DataAccessFactory;
import org.geotools.data.DataStore;
import org.geotools.data.DataStoreFactorySpi;
import org.geotools.http.HTTPClient;
import org.geotools.http.HTTPClientFinder;
import org.geotools.http.HTTPConnectionPooling;
import org.geotools.http.SimpleHttpClient;
import org.geotools.stac.client.STACClient;
import org.geotools.stac.store.STACDataStore;
import org.geotools.util.KVP;
import org.geotools.util.factory.Hints;

public class STACDataStoreFactory
implements DataStoreFactorySpi {
    public static final DataAccessFactory.Param DBTYPE = new DataAccessFactory.Param("dbtype", String.class, "Type", true, (Object)"stac", Collections.singletonMap("level", "program"));
    public static final DataAccessFactory.Param LANDING_PAGE = new DataAccessFactory.Param("landingPage", URL.class, "The STAC server landing page URL", true);
    public static final DataAccessFactory.Param NAMESPACE = new DataAccessFactory.Param("namespace", URI.class, "uri to the namespace", false, null, (Map)new KVP(new Object[]{"level", "advanced"}));
    public static final DataAccessFactory.Param SEARCH_MODE = new DataAccessFactory.Param("searchMode", STACClient.SearchMode.class, "How to perform search queries, GET, POST or decide based on conformance classes", false, (Object)STACClient.SearchMode.GET, Collections.singletonMap("options", Arrays.asList(STACClient.SearchMode.values())));
    public static final DataAccessFactory.Param FETCH_SIZE = new DataAccessFactory.Param("fetchSize", Integer.class, "How many items to fetch in a single request (just a suggestion to the server)", false, (Object)1000, Collections.singletonMap("min", 1));
    public static final DataAccessFactory.Param FEATURE_TYPE_ITEMS = new DataAccessFactory.Param("featureTypeItems", Integer.class, "How many items to fetch in order to guess the items structure", false, (Object)100, Collections.singletonMap("min", 1));
    public static final DataAccessFactory.Param HARD_LIMIT = new DataAccessFactory.Param("hardLimit", Integer.class, "How many items to fetch from a collection, tops, even while paging. Set to zero or negative to disable.", false, (Object)STACDataStore.DEFAULT_HARD_LIMIT, Collections.singletonMap("min", 1));
    public static final DataAccessFactory.Param USE_CONNECTION_POOLING = new DataAccessFactory.Param("useConnectionPooling", Boolean.class, "Use HTTP connection pooling", false, (Object)Boolean.TRUE);
    public static final DataAccessFactory.Param MAX_CONNECTIONS = new DataAccessFactory.Param("maxConnections", Integer.class, "Maximum number of connections", false, (Object)6, Collections.singletonMap("min", 1));
    public static final DataAccessFactory.Param TRY_GZIP = new DataAccessFactory.Param("tryGZIP", Boolean.class, "Use GZIP compression, if available", false, (Object)Boolean.TRUE);
    public static final DataAccessFactory.Param USERNAME = new DataAccessFactory.Param("username", String.class, "User name for HTTP basic authentication", false);
    public static final DataAccessFactory.Param PASSWORD = new DataAccessFactory.Param("password", String.class, "Password for HTTP basic authentication", false, (Object)Boolean.TRUE);
    public static final DataAccessFactory.Param CONNECTION_TIMEOUT = new DataAccessFactory.Param("connectionTimeout", Integer.class, "Connection timeout (sec)", false, (Object)10);
    public static final DataAccessFactory.Param READ_TIMEOUT = new DataAccessFactory.Param("readTimeout", Integer.class, "Read timeout (sec)", false, (Object)10);

    public String getDisplayName() {
        return "STAC-API";
    }

    public String getDescription() {
        return "Spatio-Temporal Asset Catalog API datastore";
    }

    public DataAccessFactory.Param[] getParametersInfo() {
        return new DataAccessFactory.Param[]{NAMESPACE, DBTYPE, LANDING_PAGE, SEARCH_MODE, FETCH_SIZE, FEATURE_TYPE_ITEMS, HARD_LIMIT, USE_CONNECTION_POOLING, MAX_CONNECTIONS, TRY_GZIP, USERNAME, PASSWORD, CONNECTION_TIMEOUT, READ_TIMEOUT};
    }

    public boolean isAvailable() {
        return true;
    }

    public DataStore createDataStore(Map<String, ?> params) throws IOException {
        HTTPClient http = this.buildHttpClient(params);
        URL landingPage = (URL)LANDING_PAGE.lookUp(params);
        STACClient client = new STACClient(landingPage, http);
        URI namespace = (URI)NAMESPACE.lookUp(params);
        STACClient.SearchMode mode = (STACClient.SearchMode)((Object)SEARCH_MODE.lookUp(params));
        Integer fetchSize = (Integer)FETCH_SIZE.lookUp(params);
        Integer featureTypeItems = (Integer)FEATURE_TYPE_ITEMS.lookUp(params);
        Integer hardLimit = (Integer)HARD_LIMIT.lookUp(params);
        STACDataStore store = new STACDataStore(client);
        if (namespace != null) {
            store.setNamespaceURI(namespace.toString());
        }
        if (mode != null) {
            store.setSearchMode(mode);
        }
        if (fetchSize != null) {
            store.setFetchSize(fetchSize);
        }
        if (featureTypeItems != null) {
            store.setFeatureTypeItems(featureTypeItems);
        }
        if (hardLimit != null) {
            store.setHardLimit(hardLimit);
        }
        return store;
    }

    private HTTPClient buildHttpClient(Map<String, ?> params) throws IOException {
        String username;
        Integer rt;
        Integer ct;
        HTTPClient client;
        Boolean pooling = (Boolean)USE_CONNECTION_POOLING.lookUp(params);
        if (Boolean.TRUE.equals(pooling)) {
            client = HTTPClientFinder.createClient((Class[])new Class[]{HTTPConnectionPooling.class});
            HTTPConnectionPooling pc = (HTTPConnectionPooling)client;
            Integer maxConnections = (Integer)MAX_CONNECTIONS.lookUp(params);
            if (maxConnections != null) {
                pc.setMaxConnections(maxConnections.intValue());
            }
        } else {
            client = HTTPClientFinder.createClient((Hints)new Hints((RenderingHints.Key)Hints.HTTP_CLIENT, SimpleHttpClient.class));
        }
        Boolean gzip = (Boolean)TRY_GZIP.lookUp(params);
        if (gzip != null) {
            client.setTryGzip(gzip.booleanValue());
        }
        if ((ct = (Integer)CONNECTION_TIMEOUT.lookUp(params)) != null) {
            client.setConnectTimeout(ct.intValue());
        }
        if ((rt = (Integer)READ_TIMEOUT.lookUp(params)) != null) {
            client.setReadTimeout(rt.intValue());
        }
        if ((username = (String)USERNAME.lookUp(params)) != null) {
            client.setUser(username);
            client.setPassword((String)PASSWORD.lookUp(params));
        }
        return client;
    }

    public DataStore createNewDataStore(Map<String, ?> params) throws IOException {
        throw new UnsupportedOperationException();
    }
}

