/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.stac.client;

import com.bedatadriven.jackson.datatype.jts.JtsModule;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.http.HTTPClient;
import org.geotools.http.HTTPResponse;
import org.geotools.stac.client.Collection;
import org.geotools.stac.client.CollectionList;
import org.geotools.stac.client.HttpMethod;
import org.geotools.stac.client.Link;
import org.geotools.stac.client.STACConformance;
import org.geotools.stac.client.STACGeoJSONReader;
import org.geotools.stac.client.STACLandingPage;
import org.geotools.stac.client.SearchGetBuilder;
import org.geotools.stac.client.SearchQuery;
import org.geotools.util.logging.Logging;
import org.opengis.feature.simple.SimpleFeatureType;

public class STACClient
implements Closeable {
    static final Logger LOGGER = Logging.getLogger(STACClient.class);
    public static final String JSON_MIME = "application/json";
    public static final String GEOJSON_MIME = "application/geo+json";
    private static final Map<String, String> ACCEPTS_JSON = Collections.singletonMap("Accepts", "application/json");
    static ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private final HTTPClient http;
    private final STACLandingPage landingPage;

    public STACClient(URL landingPageURL, HTTPClient http) throws IOException {
        this.http = http;
        HTTPResponse response = http.get(landingPageURL, ACCEPTS_JSON);
        this.checkJSONResponse(response);
        try (InputStream is = response.getResponseStream();){
            this.landingPage = (STACLandingPage)OBJECT_MAPPER.readValue(is, STACLandingPage.class);
        }
    }

    private void checkJSONResponse(HTTPResponse response) {
        String mime = response.getContentType();
        if (mime == null || !mime.startsWith(JSON_MIME)) {
            throw new IllegalArgumentException("Was expecting a JSON response, got a different mime type: " + mime);
        }
    }

    private void checkGeoJSONResponse(HTTPResponse response) {
        String mime = response.getContentType();
        if (mime == null || !mime.startsWith(GEOJSON_MIME)) {
            throw new IllegalArgumentException("Was expecting a GeoJSON response, got a different mime type: " + mime);
        }
    }

    public STACLandingPage getLandingPage() {
        return this.landingPage;
    }

    @Override
    public void close() throws IOException {
        if (this.http instanceof Closeable) {
            ((Closeable)this.http).close();
        }
    }

    public List<Collection> getCollections() throws IOException {
        Optional<Link> maybeData = this.landingPage.getLinks().stream().filter(this::isDataJSONLink).findFirst();
        if (!maybeData.isPresent()) {
            maybeData = this.landingPage.getLinks().stream().filter(this::isChildrenJSONLink).findFirst();
        }
        if (!maybeData.isPresent()) {
            return Collections.emptyList();
        }
        HTTPResponse response = this.http.get(new URL(maybeData.get().getHref()));
        this.checkJSONResponse(response);
        try (InputStream is = response.getResponseStream();){
            List<Collection> list = ((CollectionList)OBJECT_MAPPER.readValue(is, CollectionList.class)).getCollections().stream().filter(c -> c.getType() == null || "collection".equalsIgnoreCase(c.getType())).collect(Collectors.toList());
            return list;
        }
    }

    private boolean isDataJSONLink(Link l) {
        return l.getRel().equals("data") && (StringUtils.isEmpty((CharSequence)l.getType()) || l.getType().equals(JSON_MIME));
    }

    private boolean isChildrenJSONLink(Link l) {
        return l.getRel().equals("children") && (StringUtils.isEmpty((CharSequence)l.getType()) || l.getType().equals(JSON_MIME));
    }

    public SimpleFeatureCollection search(SearchQuery search, SearchMode mode) throws IOException {
        return this.search(search, mode, null);
    }

    public SimpleFeatureCollection search(SearchQuery search, SearchMode mode, SimpleFeatureType schema) throws IOException {
        SimpleFeatureCollection simpleFeatureCollection;
        if (!STACConformance.ITEM_SEARCH.matches(this.landingPage.getConformance())) {
            throw new IllegalStateException("The server does not support the item-search conformance class, cannot query it");
        }
        HTTPResponse response = null;
        if (mode == SearchMode.GET) {
            URL getURL = new SearchGetBuilder(this.landingPage).toGetURL(search);
            LOGGER.log(Level.FINE, () -> "STAC GET search request: " + String.valueOf(getURL));
            response = this.http.get(getURL);
        } else {
            URL postURL = new URL(this.landingPage.getSearchLink(HttpMethod.POST));
            if (postURL == null) {
                throw new IllegalArgumentException("Cannot find GeoJSON search GET link");
            }
            String body = OBJECT_MAPPER.writeValueAsString((Object)search);
            LOGGER.log(Level.FINE, () -> "STAC POST search request: " + String.valueOf(postURL) + " with body:\n" + body);
            response = this.http.post(postURL, (InputStream)new ByteArrayInputStream(body.getBytes(StandardCharsets.UTF_8)), JSON_MIME);
        }
        this.checkGeoJSONResponse(response);
        STACGeoJSONReader reader = new STACGeoJSONReader(new BufferedInputStream(response.getResponseStream(), 32768), this.http);
        try {
            if (schema != null) {
                reader.setSchema(schema);
            }
            simpleFeatureCollection = reader.getFeatures();
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (URISyntaxException e) {
                throw new IOException("Failed to build the search query URL", e);
            }
        }
        reader.close();
        return simpleFeatureCollection;
    }

    public HTTPClient getHttp() {
        return this.http;
    }

    static {
        OBJECT_MAPPER.enable(SerializationFeature.WRITE_ENUMS_USING_TO_STRING);
        OBJECT_MAPPER.enable(DeserializationFeature.READ_ENUMS_USING_TO_STRING);
        OBJECT_MAPPER.registerModule((Module)new JtsModule());
        OBJECT_MAPPER.setDefaultPropertyInclusion(JsonInclude.Include.NON_EMPTY);
    }

    public static enum SearchMode {
        GET,
        POST;

    }
}

