/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.stac.client;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Optional;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.DoubleStream;
import org.apache.http.client.utils.URIBuilder;
import org.geootols.filter.text.cql_2.CQL2;
import org.geotools.filter.text.cqljson.CQL2Json;
import org.geotools.stac.client.FilterLang;
import org.geotools.stac.client.GeometryDefaulter;
import org.geotools.stac.client.HttpMethod;
import org.geotools.stac.client.STACClient;
import org.geotools.stac.client.STACLandingPage;
import org.geotools.stac.client.SearchQuery;
import org.geotools.stac.client.SortBy;
import org.opengis.filter.Filter;

class SearchGetBuilder {
    private static final Collector<CharSequence, ?, String> COMMA_JOINER = Collectors.joining(",");
    STACLandingPage landingPage;

    public SearchGetBuilder(STACLandingPage landingPage) {
        this.landingPage = landingPage;
    }

    URL toGetURL(SearchQuery search) throws MalformedURLException, URISyntaxException {
        String spec;
        Filter filter;
        String spec2;
        String base = this.landingPage.getSearchLink(HttpMethod.GET);
        if (base == null) {
            throw new IllegalArgumentException("Cannot find GeoJSON search GET link");
        }
        URIBuilder builder = new URIBuilder(base);
        if (search.getBbox() != null) {
            spec2 = DoubleStream.of(search.getBbox()).mapToObj(String::valueOf).collect(COMMA_JOINER);
            builder.addParameter("bbox", spec2);
        }
        if (search.getCollections() != null) {
            spec2 = search.getCollections().stream().collect(COMMA_JOINER);
            builder.addParameter("collections", spec2);
        }
        if (search.getDatetime() != null) {
            builder.addParameter("datetime", search.getDatetime());
        }
        if (search.getIntersects() != null) {
            try {
                builder.addParameter("intersects", STACClient.OBJECT_MAPPER.writeValueAsString((Object)search.getIntersects()));
            }
            catch (JsonProcessingException e) {
                throw new RuntimeException(e);
            }
        }
        if ((filter = search.getFilter()) != null) {
            String spec3;
            FilterLang lang = Optional.ofNullable(search.getFilterLang()).orElse(FilterLang.CQL2_TEXT);
            Filter defaulted = GeometryDefaulter.defaultGeometry(filter);
            if (FilterLang.CQL2_TEXT.equals((Object)lang)) {
                spec3 = CQL2.toCQL2((Filter)defaulted);
            } else if (FilterLang.CQL2_JSON.equals((Object)lang)) {
                spec3 = CQL2Json.toCQL2((Filter)defaulted);
            } else {
                throw new IllegalArgumentException("Unrecognized filter language: " + String.valueOf((Object)lang));
            }
            builder.addParameter("filter", spec3);
            builder.addParameter("filter-lang", lang.toString());
        }
        if (search.getLimit() != null) {
            builder.addParameter("limit", String.valueOf(search.getLimit()));
        }
        if (search.getFields() != null) {
            spec = search.getFields().stream().collect(COMMA_JOINER);
            builder.addParameter("fields", spec);
        }
        if (search.getSortBy() != null) {
            spec = search.getSortBy().stream().map(sb -> SearchGetBuilder.getSortSpecification(sb)).collect(COMMA_JOINER);
            builder.addParameter("sortby", spec);
        }
        return builder.build().toURL();
    }

    private static String getSortSpecification(SortBy sb) {
        return (sb.getDirection() == SortBy.Direction.desc ? "-" : "") + sb.getField();
    }
}

