/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.solr;

import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;
import org.geotools.api.feature.Feature;
import org.geotools.api.filter.Filter;
import org.geotools.api.filter.FilterFactory;
import org.geotools.api.filter.PropertyIsLike;
import org.geotools.api.filter.expression.Expression;
import org.geotools.data.complex.TotalIndexedMappingFeatureIterator;
import org.geotools.data.complex.feature.type.Types;
import org.geotools.data.solr.AppSchemaOnlineTestSupport;
import org.geotools.data.util.FeatureStreams;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.junit.Test;

public class AppSchemaIndexIntegrationTest
extends AppSchemaOnlineTestSupport {
    protected FilterFactory ff = CommonFactoryFinder.getFilterFactory();
    protected final String attId = "st:Station";
    protected final String attName = "st:Station/st:stationName";
    protected final String attComments = "st:Station/st:comments";
    protected final String attObservationDesc = "st:Station/st:observation/st:Observation/st:description";

    @Test
    public void testIndex() throws IOException {
        this.totalindexCase();
    }

    private void totalindexCase() throws IOException {
        FeatureCollection fcoll = this.mappingDataStore.getFeatureSource(this.mappedTypeName).getFeatures(this.totalIndexedFilterCase());
        try (FeatureIterator iterator = fcoll.features();){
            AppSchemaIndexIntegrationTest.assertTrue((boolean)(iterator instanceof TotalIndexedMappingFeatureIterator));
        }
        List features = FeatureStreams.toFeatureStream((FeatureCollection)fcoll).collect(Collectors.toList());
        AppSchemaIndexIntegrationTest.assertEquals((int)features.size(), (int)1);
        AppSchemaIndexIntegrationTest.assertEquals((String)((Feature)features.get(0)).getIdentifier().getID(), (String)"13");
    }

    @Override
    protected void configFieldsSetup() {
        this.mappedTypeName = Types.typeName((String)"StationType-f46d72da-5591-4873-b210-5ed30a6ffb0d");
        this.xmlFileName = "mappings_solr.xml";
        this.xsdFileName = "meteo.xsd";
        this.testData = "/test-data/appschema-indexes/stations_complex/";
    }

    private Filter totalIndexedFilterCase() {
        FilterFactory ff = CommonFactoryFinder.getFilterFactory();
        PropertyIsLike filter = ff.like((Expression)ff.property("st:Station/st:observation/st:Observation/st:description"), "*sky*");
        return filter;
    }

    @Override
    protected void prepareFiles() throws Exception {
        this.copyTestData(this.xsdFileName, this.tempDir);
        this.copyTestData(this.xmlFileName, this.tempDir);
        this.copyTestData("includedTypes.xml", this.tempDir);
    }

    @Override
    protected void solrDataSetup() {
    }

    @Override
    protected String getFixtureId() {
        return "appschema_index";
    }
}

