/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.solr.complex;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.io.FileUtils;
import org.apache.solr.client.solrj.impl.HttpSolrClient;
import org.geotools.api.data.DataAccess;
import org.geotools.api.data.DataAccessFinder;
import org.geotools.api.data.FeatureSource;
import org.geotools.api.feature.Feature;
import org.geotools.api.feature.Property;
import org.geotools.api.feature.type.FeatureType;
import org.geotools.api.feature.type.Name;
import org.geotools.data.complex.feature.type.Types;
import org.geotools.data.solr.TestsSolrUtils;
import org.geotools.data.solr.complex.StationsSetup;
import org.geotools.feature.FeatureIterator;
import org.geotools.feature.NameImpl;
import org.geotools.test.OnlineTestCase;
import org.geotools.util.logging.Logging;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.AfterClass;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.Point;

public final class ComplexFeaturesTest
extends OnlineTestCase {
    private static final Logger LOGGER = Logging.getLogger(ComplexFeaturesTest.class);
    private static final Name MAPPED_TYPE_NAME = Types.typeName((String)"stations_solr");
    private static final String STATIONS_NAMESPACE = "http://www.stations.org/1.0";
    private static final Name STATION_NAME = new NameImpl("http://www.stations.org/1.0", "stationName");
    private static final Name STATION_TAG = new NameImpl("http://www.stations.org/1.0", "tag");
    private static final File TESTS_ROOT_DIR = TestsSolrUtils.createTempDirectory("complex-solr");
    private DataAccess<FeatureType, Feature> appSchemaDataStore;

    public void setUpInternal() throws IOException {
        try (HttpSolrClient client = new HttpSolrClient.Builder(this.getSolrCoreURL()).build();){
            StationsSetup.setupSolrIndex(client);
        }
        StationsSetup.prepareAppSchemaFiles(TESTS_ROOT_DIR, this.getSolrCoreURL());
        this.instantiateAppSchemaDataStore();
    }

    @AfterClass
    public static void cleanUp() {
        try {
            FileUtils.deleteDirectory((File)TESTS_ROOT_DIR);
        }
        catch (Exception exception) {
            LOGGER.log(Level.WARNING, String.format("Error removing tests root directory '%s'.", TESTS_ROOT_DIR.getAbsolutePath()), exception);
        }
    }

    public void testRetrievingStationsComplexFeatures() throws Exception {
        FeatureSource source = this.appSchemaDataStore.getFeatureSource(MAPPED_TYPE_NAME);
        List<Feature> features = this.iteratorToList((FeatureIterator<Feature>)source.getFeatures().features());
        ComplexFeaturesTest.assertEquals((int)2, (int)features.size());
        GeometryFactory geometryFactory = new GeometryFactory();
        this.checkFeatureExists(features, "7", "Bologna", geometryFactory.createPoint(new Coordinate(11.34, 44.5)), new String[0]);
        this.checkFeatureExists(features, "13", "Alessandria", geometryFactory.createPoint(new Coordinate(8.63, 44.92)), "ALS_TAG_1", "ALS_TAG_2");
    }

    private Feature checkFeatureExists(List<Feature> features, String id, String name, Point position, String ... tags) {
        for (Feature feature : features) {
            if (!feature.getIdentifier().getID().equals(id)) continue;
            Property nameProperty = feature.getProperty(STATION_NAME);
            MatcherAssert.assertThat((Object)nameProperty, (Matcher)CoreMatchers.notNullValue());
            MatcherAssert.assertThat((Object)nameProperty.getValue(), (Matcher)CoreMatchers.notNullValue());
            MatcherAssert.assertThat((Object)nameProperty.getValue(), (Matcher)CoreMatchers.instanceOf(String.class));
            MatcherAssert.assertThat((Object)feature.getDefaultGeometryProperty(), (Matcher)CoreMatchers.notNullValue());
            Object geometryValue = feature.getDefaultGeometryProperty().getValue();
            MatcherAssert.assertThat((Object)geometryValue, (Matcher)CoreMatchers.notNullValue());
            MatcherAssert.assertThat((Object)geometryValue, (Matcher)CoreMatchers.instanceOf(Point.class));
            MatcherAssert.assertThat((Object)geometryValue, (Matcher)CoreMatchers.is((Object)position));
            Collection tagProperties = feature.getProperties(STATION_TAG);
            MatcherAssert.assertThat((Object)tagProperties.size(), (Matcher)CoreMatchers.is((Object)tags.length));
            for (Property tagProperty : tagProperties) {
                MatcherAssert.assertThat((Object)tagProperty, (Matcher)CoreMatchers.notNullValue());
                Object tagValue = tagProperty.getValue();
                MatcherAssert.assertThat((Object)tagValue, (Matcher)CoreMatchers.notNullValue());
                MatcherAssert.assertThat((Object)tagValue, (Matcher)CoreMatchers.instanceOf(String.class));
                int index = Arrays.binarySearch(tags, tagValue);
                MatcherAssert.assertThat((Object)(index >= 0 ? 1 : 0), (Matcher)CoreMatchers.is((Object)true));
                MatcherAssert.assertThat((Object)tags[index], (Matcher)CoreMatchers.is((Object)tagValue));
            }
            return feature;
        }
        ComplexFeaturesTest.fail((String)"Feature not found");
        return null;
    }

    private List<Feature> iteratorToList(FeatureIterator<Feature> iterator) {
        ArrayList<Feature> features = new ArrayList<Feature>();
        while (iterator.hasNext()) {
            features.add(iterator.next());
        }
        return features;
    }

    private void instantiateAppSchemaDataStore() {
        URI mappingsFiles = new File(TESTS_ROOT_DIR, "mappings.xml").toURI();
        HashMap<String, String> dataStoreParameters = new HashMap<String, String>();
        dataStoreParameters.put("dbtype", "app-schema");
        dataStoreParameters.put("url", mappingsFiles.toString());
        try {
            this.appSchemaDataStore = DataAccessFinder.getDataStore(dataStoreParameters);
        }
        catch (Exception exception) {
            throw new RuntimeException("Error instantiating App-Schema data store.", exception);
        }
    }

    private String getSolrCoreURL() {
        return this.fixture.getProperty("solr_url");
    }

    protected String getFixtureId() {
        return "solr";
    }

    static {
        if (System.getProperty("schema.cache.dir") == null) {
            System.setProperty("schema.cache.dir", new File(TESTS_ROOT_DIR, "app-schema-cache").getAbsolutePath());
        }
    }
}

