/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.solr;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.geotools.api.data.Query;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.feature.type.GeometryDescriptor;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.data.solr.SolrDataStore;
import org.geotools.data.solr.SolrDataStoreFactory;
import org.geotools.data.solr.SolrTestSupport;
import org.geotools.data.store.ContentFeatureSource;
import org.locationtech.jts.geom.Geometry;

public class SolrSingleLayerMappingTest
extends SolrTestSupport {
    @Override
    protected void setUpInternal() throws Exception {
        super.setUpInternal();
    }

    @Override
    protected Map<String, Object> createConnectionParams(String url, Properties fixture) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(SolrDataStoreFactory.URL.key, url);
        params.put(SolrDataStoreFactory.LAYER_MAPPER.key, "SINGLE");
        params.put(SolrDataStoreFactory.NAMESPACE.key, SolrDataStoreFactory.NAMESPACE.sample);
        return params;
    }

    public void testTypeNames() throws Exception {
        String[] names = this.dataStore.getTypeNames();
        SolrSingleLayerMappingTest.assertEquals((int)1, (int)names.length);
        SolrSingleLayerMappingTest.assertEquals((String)names[0], (String)this.coreName(this.dataStore));
    }

    public void testSchema() throws Exception {
        this.init(this.coreName(this.dataStore));
        SimpleFeatureType schema = this.dataStore.getSchema(this.coreName(this.dataStore));
        SolrSingleLayerMappingTest.assertNotNull((Object)schema);
        SolrSingleLayerMappingTest.assertNotNull((Object)schema.getGeometryDescriptor());
        SolrSingleLayerMappingTest.assertTrue((boolean)(schema.getDescriptor("geo") instanceof GeometryDescriptor));
        SolrSingleLayerMappingTest.assertTrue((boolean)(schema.getDescriptor("geo2") instanceof GeometryDescriptor));
        SolrSingleLayerMappingTest.assertTrue((boolean)(schema.getDescriptor("geo3") instanceof GeometryDescriptor));
    }

    public void testFeatureSource() throws Exception {
        this.init(this.coreName(this.dataStore));
        ContentFeatureSource featureSource = this.dataStore.getFeatureSource(this.coreName(this.dataStore));
        SolrSingleLayerMappingTest.assertEquals((int)13, (int)featureSource.getCount(Query.ALL));
        SimpleFeatureCollection features = featureSource.getFeatures(Query.ALL);
        try (SimpleFeatureIterator it = features.features();){
            while (it.hasNext()) {
                SimpleFeature f = (SimpleFeature)it.next();
                SolrSingleLayerMappingTest.assertTrue((boolean)(f.getAttribute("geo") instanceof Geometry));
                SolrSingleLayerMappingTest.assertTrue((boolean)(f.getAttribute("geo2") instanceof Geometry));
                SolrSingleLayerMappingTest.assertTrue((boolean)(f.getAttribute("geo3") instanceof Geometry));
            }
        }
    }

    String coreName(SolrDataStore dataStore) {
        String[] split = dataStore.getSolrServer().getBaseURL().split("/");
        return split[split.length - 1];
    }
}

