/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.solr;

import java.util.Arrays;
import java.util.HashSet;
import org.geotools.api.data.Query;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.feature.type.GeometryDescriptor;
import org.geotools.api.filter.And;
import org.geotools.api.filter.Filter;
import org.geotools.api.filter.FilterFactory;
import org.geotools.api.filter.Id;
import org.geotools.api.filter.Not;
import org.geotools.api.filter.Or;
import org.geotools.api.filter.PropertyIsBetween;
import org.geotools.api.filter.PropertyIsEqualTo;
import org.geotools.api.filter.PropertyIsGreaterThan;
import org.geotools.api.filter.PropertyIsGreaterThanOrEqualTo;
import org.geotools.api.filter.PropertyIsLessThan;
import org.geotools.api.filter.PropertyIsLessThanOrEqualTo;
import org.geotools.api.filter.PropertyIsLike;
import org.geotools.api.filter.PropertyIsNotEqualTo;
import org.geotools.api.filter.PropertyIsNull;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.filter.identity.FeatureId;
import org.geotools.api.filter.sort.SortBy;
import org.geotools.api.filter.sort.SortOrder;
import org.geotools.api.filter.spatial.BBOX;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.data.solr.SolrTestSupport;
import org.geotools.data.store.ContentFeatureCollection;
import org.geotools.geometry.jts.ReferencedEnvelope;

public class SolrFeatureSourceTest
extends SolrTestSupport {
    public void testSchema() throws Exception {
        this.init();
        SimpleFeatureType schema = this.featureSource.getSchema();
        SolrFeatureSourceTest.assertNotNull((Object)schema);
        SolrFeatureSourceTest.assertNotNull((Object)schema.getGeometryDescriptor());
        SolrFeatureSourceTest.assertTrue((boolean)(schema.getDescriptor("geo") instanceof GeometryDescriptor));
        SolrFeatureSourceTest.assertTrue((boolean)(schema.getDescriptor("geo2") instanceof GeometryDescriptor));
        SolrFeatureSourceTest.assertTrue((boolean)(schema.getDescriptor("geo3") instanceof GeometryDescriptor));
    }

    public void testCount() throws Exception {
        this.init();
        SolrFeatureSourceTest.assertEquals((int)13, (int)this.featureSource.getCount(Query.ALL));
    }

    public void testBounds() throws Exception {
        this.init();
        ReferencedEnvelope bounds = this.featureSource.getBounds();
        SolrFeatureSourceTest.assertEquals((long)0L, (long)Math.round(bounds.getMinX()));
        SolrFeatureSourceTest.assertEquals((long)0L, (long)Math.round(bounds.getMinY()));
        SolrFeatureSourceTest.assertEquals((long)24L, (long)Math.round(bounds.getMaxX()));
        SolrFeatureSourceTest.assertEquals((long)44L, (long)Math.round(bounds.getMaxY()));
    }

    public void testCountWithIsEqualFilter() throws Exception {
        this.init();
        FilterFactory ff = this.dataStore.getFilterFactory();
        PropertyIsEqualTo filter = ff.equals((Expression)ff.property("vendor_s"), (Expression)ff.literal((Object)"D-Link"));
        Query query = new Query();
        query.setFilter((Filter)filter);
        SolrFeatureSourceTest.assertEquals((int)4, (int)this.featureSource.getCount(query));
    }

    public void testCountWithIsNotEqualFilter() throws Exception {
        this.init();
        FilterFactory ff = this.dataStore.getFilterFactory();
        PropertyIsNotEqualTo filter = ff.notEqual((Expression)ff.property("vendor_s"), (Expression)ff.literal((Object)"D-Link"));
        Query query = new Query();
        query.setFilter((Filter)filter);
        SolrFeatureSourceTest.assertEquals((int)7, (int)this.featureSource.getCount(query));
    }

    public void testCountWithOffsetLimit() throws Exception {
        this.init();
        Query query = new Query();
        query.setStartIndex(Integer.valueOf(5));
        query.setMaxFeatures(11);
        SolrFeatureSourceTest.assertEquals((int)8, (int)this.featureSource.getCount(query));
    }

    public void testGetFeaturesWithAndLogicFilter() throws Exception {
        this.init();
        FilterFactory ff = this.dataStore.getFilterFactory();
        PropertyIsEqualTo property = ff.equals((Expression)ff.property("standard_ss"), (Expression)ff.literal((Object)"IEEE 802.11b"));
        BBOX bbox = ff.bbox("geo", -1.0, -1.0, 10.0, 10.0, "EPSG:" + this.SOURCE_SRID);
        And filter = ff.and((Filter)property, (Filter)bbox);
        ContentFeatureCollection features = this.featureSource.getFeatures((Filter)filter);
        SolrFeatureSourceTest.assertEquals((int)3, (int)features.size());
    }

    public void testGetFeaturesWithORLogicFilter() throws Exception {
        this.init();
        FilterFactory ff = this.dataStore.getFilterFactory();
        PropertyIsEqualTo property1 = ff.equals((Expression)ff.property("vendor_s"), (Expression)ff.literal((Object)"D-Link"));
        PropertyIsEqualTo property2 = ff.equals((Expression)ff.property("vendor_s"), (Expression)ff.literal((Object)"Linksys"));
        Or filter = ff.or((Filter)property1, (Filter)property2);
        ContentFeatureCollection features = this.featureSource.getFeatures((Filter)filter);
        SolrFeatureSourceTest.assertEquals((int)4, (int)features.size());
        try (SimpleFeatureIterator iterator = features.features();){
            while (iterator.hasNext()) {
                SimpleFeature f = (SimpleFeature)iterator.next();
                SolrFeatureSourceTest.assertTrue((f.getAttribute("vendor_s").equals("D-Link") || f.getAttribute("vendor_s").equals("Linksys") ? 1 : 0) != 0);
            }
        }
    }

    public void testGetFeaturesWithNOTLogicFilter() throws Exception {
        this.init();
        FilterFactory ff = this.dataStore.getFilterFactory();
        PropertyIsEqualTo property1 = ff.equals((Expression)ff.property("vendor_s"), (Expression)ff.literal((Object)"D-Link"));
        Not filter = ff.not((Filter)property1);
        ContentFeatureCollection features = this.featureSource.getFeatures((Filter)filter);
        SolrFeatureSourceTest.assertEquals((int)7, (int)features.size());
        try (SimpleFeatureIterator iterator = features.features();){
            while (iterator.hasNext()) {
                SimpleFeature f = (SimpleFeature)iterator.next();
                SolrFeatureSourceTest.assertFalse((boolean)f.getAttribute("vendor_s").equals("D-Link"));
            }
        }
    }

    public void testGetFeaturesWithIdFilter() throws Exception {
        this.init();
        FilterFactory ff = this.dataStore.getFilterFactory();
        Id id = ff.id(new HashSet<FeatureId>(Arrays.asList(ff.featureId(this.layerName + ".1"), ff.featureId(this.layerName + ".7"))));
        ContentFeatureCollection features = this.featureSource.getFeatures((Filter)id);
        SolrFeatureSourceTest.assertEquals((int)2, (int)features.size());
        try (SimpleFeatureIterator iterator = features.features();){
            SolrFeatureSourceTest.assertTrue((boolean)iterator.hasNext());
            SimpleFeature f = (SimpleFeature)iterator.next();
            SolrFeatureSourceTest.assertFalse((boolean)f.getAttribute(this.pkField).equals(1));
            SolrFeatureSourceTest.assertTrue((boolean)iterator.hasNext());
            f = (SimpleFeature)iterator.next();
            SolrFeatureSourceTest.assertFalse((boolean)f.getAttribute(this.pkField).equals(7));
        }
    }

    public void testGetFeaturesWithBetweenFilter() throws Exception {
        int si;
        boolean found;
        SimpleFeature f;
        this.init();
        FilterFactory ff = this.dataStore.getFilterFactory();
        PropertyIsBetween between = ff.between((Expression)ff.property("speed_is"), (Expression)ff.literal(0), (Expression)ff.literal(150));
        ContentFeatureCollection features = this.featureSource.getFeatures((Filter)between);
        SolrFeatureSourceTest.assertEquals((int)9, (int)features.size());
        try (SimpleFeatureIterator iterator = features.features();){
            while (iterator.hasNext()) {
                f = (SimpleFeature)iterator.next();
                found = false;
                if (!(f.getAttribute("speed_is") instanceof String)) {
                    int v = (Integer)f.getAttribute("speed_is");
                    found = v >= 0 && v <= 150;
                } else {
                    String speeds = (String)f.getAttribute("speed_is");
                    for (String s : speeds.split(";")) {
                        si = Integer.parseInt(s.toString());
                        if (si < 0 || si > 150) continue;
                        found = true;
                        break;
                    }
                }
                SolrFeatureSourceTest.assertTrue((boolean)found);
            }
        }
        between = ff.between((Expression)ff.property("speed_is"), (Expression)ff.literal(160), (Expression)ff.literal(300));
        features = this.featureSource.getFeatures((Filter)between);
        SolrFeatureSourceTest.assertEquals((int)5, (int)features.size());
        iterator = features.features();
        try {
            while (iterator.hasNext()) {
                f = (SimpleFeature)iterator.next();
                found = false;
                if (!(f.getAttribute("speed_is") instanceof String)) {
                    int v = (Integer)f.getAttribute("speed_is");
                    found = v >= 160 && v <= 300;
                } else {
                    String speeds = (String)f.getAttribute("speed_is");
                    for (String s : speeds.split(";")) {
                        si = Integer.parseInt(s.toString());
                        if (si < 160 || si > 300) continue;
                        found = true;
                        break;
                    }
                }
                SolrFeatureSourceTest.assertTrue((boolean)found);
            }
        }
        finally {
            if (iterator != null) {
                iterator.close();
            }
        }
    }

    public void testGetFeaturesWithQuery() throws Exception {
        this.init();
        FilterFactory ff = this.dataStore.getFilterFactory();
        PropertyIsEqualTo filter = ff.equals((Expression)ff.property("modem_b"), (Expression)ff.literal(true));
        Query query = new Query();
        query.setPropertyNames(new String[]{"standard_ss", "security_ss"});
        query.setFilter((Filter)filter);
        ContentFeatureCollection features = this.featureSource.getFeatures(query);
        SolrFeatureSourceTest.assertEquals((int)8, (int)features.size());
        try (SimpleFeatureIterator iterator = features.features();){
            SolrFeatureSourceTest.assertTrue((boolean)iterator.hasNext());
            SimpleFeature feature = (SimpleFeature)iterator.next();
            SolrFeatureSourceTest.assertEquals((int)2, (int)feature.getAttributeCount());
            String st = (String)feature.getAttribute("standard_ss");
            SolrFeatureSourceTest.assertTrue((boolean)st.contains("IEEE 802.11b"));
        }
    }

    public void testGetFeaturesWithSort() throws Exception {
        SimpleFeature f;
        this.init();
        FilterFactory ff = this.dataStore.getFilterFactory();
        SortBy sort = ff.sort("vendor_s", SortOrder.ASCENDING);
        Query query = new Query();
        query.setSortBy(new SortBy[]{sort});
        ContentFeatureCollection features = this.featureSource.getFeatures(query);
        SolrFeatureSourceTest.assertEquals((int)13, (int)features.size());
        try (SimpleFeatureIterator iterator = features.features();){
            for (int i = 0; i < 3; ++i) {
                SolrFeatureSourceTest.assertTrue((boolean)iterator.hasNext());
                SimpleFeature f2 = (SimpleFeature)iterator.next();
                SolrFeatureSourceTest.assertEquals((Object)"Asus", (Object)f2.getAttribute("vendor_s"));
            }
            SolrFeatureSourceTest.assertTrue((boolean)iterator.hasNext());
            f = (SimpleFeature)iterator.next();
            SolrFeatureSourceTest.assertEquals((Object)"Cisco", (Object)f.getAttribute("vendor_s"));
            SolrFeatureSourceTest.assertTrue((boolean)iterator.hasNext());
            f = (SimpleFeature)iterator.next();
            SolrFeatureSourceTest.assertEquals((Object)"Cisco", (Object)f.getAttribute("vendor_s"));
        }
        sort = ff.sort("vendor_s", SortOrder.DESCENDING);
        query.setSortBy(new SortBy[]{sort});
        iterator = this.featureSource.getFeatures(query).features();
        try {
            SolrFeatureSourceTest.assertTrue((boolean)iterator.hasNext());
            f = (SimpleFeature)iterator.next();
            SolrFeatureSourceTest.assertEquals((Object)"TP-Link", (Object)f.getAttribute("vendor_s"));
            SolrFeatureSourceTest.assertTrue((boolean)iterator.hasNext());
            f = (SimpleFeature)iterator.next();
            SolrFeatureSourceTest.assertEquals((Object)"Linksys", (Object)f.getAttribute("vendor_s"));
            SolrFeatureSourceTest.assertTrue((boolean)iterator.hasNext());
            f = (SimpleFeature)iterator.next();
            SolrFeatureSourceTest.assertEquals((Object)"Linksys", (Object)f.getAttribute("vendor_s"));
        }
        finally {
            if (iterator != null) {
                iterator.close();
            }
        }
    }

    public void testGetFeaturesWithOffsetLimit() throws Exception {
        this.init();
        Query q = new Query(this.featureSource.getSchema().getTypeName());
        q.setStartIndex(Integer.valueOf(1));
        q.setMaxFeatures(1);
        ContentFeatureCollection features = this.featureSource.getFeatures(q);
        SolrFeatureSourceTest.assertEquals((int)1, (int)features.size());
        try (SimpleFeatureIterator it = features.features();){
            SolrFeatureSourceTest.assertTrue((boolean)it.hasNext());
            SimpleFeature f = (SimpleFeature)it.next();
            SolrFeatureSourceTest.assertEquals((int)10, (int)Integer.parseInt((String)f.getAttribute("id")));
            SolrFeatureSourceTest.assertFalse((boolean)it.hasNext());
        }
    }

    public void testNaturalSortingAsc() throws Exception {
        this.init();
        Query q = new Query(this.featureSource.getSchema().getTypeName());
        q.setSortBy(new SortBy[]{SortBy.NATURAL_ORDER});
        try (SimpleFeatureIterator features = this.featureSource.getFeatures(q).features();){
            String prevId = null;
            while (features.hasNext()) {
                String currId = ((SimpleFeature)features.next()).getID();
                if (prevId != null) {
                    SolrFeatureSourceTest.assertTrue((prevId.compareTo(currId) <= 0 ? 1 : 0) != 0);
                }
                prevId = currId;
            }
        }
    }

    public void testNaturalSortingDesc() throws Exception {
        this.init();
        Query q = new Query(this.featureSource.getSchema().getTypeName());
        q.setSortBy(new SortBy[]{SortBy.REVERSE_ORDER});
        try (SimpleFeatureIterator features = this.featureSource.getFeatures(q).features();){
            String prevId = null;
            while (features.hasNext()) {
                String currId = ((SimpleFeature)features.next()).getID();
                if (prevId != null) {
                    SolrFeatureSourceTest.assertTrue((prevId.compareTo(currId) >= 0 ? 1 : 0) != 0);
                }
                prevId = currId;
            }
        }
    }

    public void testGetFeaturesWithIsGreaterThanFilter() throws Exception {
        this.init();
        FilterFactory ff = this.dataStore.getFilterFactory();
        PropertyIsGreaterThan f = ff.greater((Expression)ff.property("speed_is"), (Expression)ff.literal(300));
        ContentFeatureCollection features = this.featureSource.getFeatures((Filter)f);
        SolrFeatureSourceTest.assertEquals((int)0, (int)features.size());
    }

    public void testGetFeaturesWithIsGreaterThanOrEqualToFilter() throws Exception {
        this.init();
        FilterFactory ff = this.dataStore.getFilterFactory();
        PropertyIsGreaterThanOrEqualTo f = ff.greaterOrEqual((Expression)ff.property("speed_is"), (Expression)ff.literal(300));
        ContentFeatureCollection features = this.featureSource.getFeatures((Filter)f);
        SolrFeatureSourceTest.assertEquals((int)5, (int)features.size());
    }

    public void testGetFeaturesWithIsLessThanFilter() throws Exception {
        this.init();
        FilterFactory ff = this.dataStore.getFilterFactory();
        PropertyIsLessThan f = ff.less((Expression)ff.property("speed_is"), (Expression)ff.literal(150));
        ContentFeatureCollection features = this.featureSource.getFeatures((Filter)f);
        SolrFeatureSourceTest.assertEquals((int)0, (int)features.size());
    }

    public void testGetFeaturesWithLessThanOrEqualToFilter() throws Exception {
        this.init();
        FilterFactory ff = this.dataStore.getFilterFactory();
        PropertyIsLessThanOrEqualTo f = ff.lessOrEqual((Expression)ff.property("speed_is"), (Expression)ff.literal(150));
        ContentFeatureCollection features = this.featureSource.getFeatures((Filter)f);
        SolrFeatureSourceTest.assertEquals((int)9, (int)features.size());
    }

    public void testGetFeaturesWithIsLikeFilter() throws Exception {
        this.init();
        FilterFactory ff = this.dataStore.getFilterFactory();
        PropertyIsLike f = ff.like((Expression)ff.property("standard_ss"), "IEEE 802.11?");
        ContentFeatureCollection features = this.featureSource.getFeatures((Filter)f);
        SolrFeatureSourceTest.assertEquals((int)11, (int)features.size());
    }

    public void testGetFeaturesWithIsNullFilter() throws Exception {
        this.init();
        FilterFactory ff = this.dataStore.getFilterFactory();
        PropertyIsNull f = ff.isNull((Expression)ff.property("security_ss"));
        ContentFeatureCollection features = this.featureSource.getFeatures((Filter)f);
        SolrFeatureSourceTest.assertEquals((int)1, (int)features.size());
    }

    public void testBBOXFilterWithBBOXType() throws Exception {
        this.init();
        FilterFactory ff = this.dataStore.getFilterFactory();
        BBOX f = ff.bbox("geo3", 12.5, 7.5, 14.0, 19.0, "epsg:4326");
        ContentFeatureCollection features = this.featureSource.getFeatures((Filter)f);
        this.assertCovered((SimpleFeatureCollection)features, 2, 5, 6);
    }

    void assertCovered(SimpleFeatureCollection features, Integer ... ids) {
        SolrFeatureSourceTest.assertEquals((int)ids.length, (int)features.size());
        HashSet<Integer> s = new HashSet<Integer>(Arrays.asList(ids));
        try (SimpleFeatureIterator it = features.features();){
            while (it.hasNext()) {
                SimpleFeature f = (SimpleFeature)it.next();
                s.remove(Integer.parseInt(f.getAttribute("id").toString()));
            }
            SolrFeatureSourceTest.assertTrue((boolean)s.isEmpty());
        }
    }
}

