/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.solr;

import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;
import org.geotools.api.data.DataAccessFactory;
import org.geotools.api.data.DataStore;
import org.geotools.api.data.DataStoreFactorySpi;
import org.geotools.data.solr.SolrDataStore;
import org.geotools.data.solr.SolrDataStoreFactory;
import org.geotools.util.factory.FactoryCreator;
import org.geotools.util.factory.FactoryRegistry;
import org.geotools.util.logging.Logging;
import org.junit.Assert;
import org.junit.Test;

public class SolrDataStoreFinderTest {
    protected static final Logger LOGGER = Logging.getLogger(SolrDataStoreFinderTest.class);
    private DataStore source;

    @Test
    public void testDbcpFactory() throws IOException {
        Assert.assertTrue((boolean)new SolrDataStoreFactory().isAvailable());
        this.scanForPlugins();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(SolrDataStoreFactory.URL.key, new URL("http://localhost:8080/solr"));
        map.put(SolrDataStoreFactory.FIELD.key, "layer_type");
        map.put(SolrDataStoreFactory.NAMESPACE.key, "namesapce");
        Iterator ps = this.getAvailableDataSources().iterator();
        while (ps.hasNext()) {
            DataStoreFactorySpi fac = (DataStoreFactorySpi)ps.next();
            try {
                if (!fac.canProcess(map)) continue;
                this.source = fac.createDataStore(map);
            }
            catch (Throwable t) {
                LOGGER.log(Level.WARNING, "Could not acquire " + fac.getDescription() + ":" + t, t);
            }
        }
        Assert.assertNotNull((Object)this.source);
        Assert.assertTrue((boolean)(this.source instanceof SolrDataStore));
    }

    private FactoryRegistry getServiceRegistry() {
        FactoryCreator registry = new FactoryCreator(Arrays.asList(DataStoreFactorySpi.class));
        return registry;
    }

    private void scanForPlugins() {
        this.getServiceRegistry().scanForPlugins();
    }

    public Stream<DataStoreFactorySpi> getAvailableDataSources() {
        return this.getServiceRegistry().getFactories(DataStoreFactorySpi.class, null, null).filter(ds -> ds instanceof SolrDataStoreFactory).filter(DataAccessFactory::isAvailable);
    }
}

